/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.ArrayList;
import java.util.Arrays;
import org.cqframework.cql.elm.execution.Except;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EndsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.NotEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.PredecessorEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.ProperIncludesEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.StartsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.UndefinedResult;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class ExceptEvaluator
extends Except {
    public static Object except(Object left, Object right, Context context) {
        if (left == null) {
            return null;
        }
        if (!(left instanceof Iterable) && right == null) {
            return null;
        }
        if (left instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart == null || leftEnd == null || rightStart == null || rightEnd == null) {
                return null;
            }
            String precision = null;
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)leftEnd, (BaseTemporal)rightStart, (BaseTemporal)rightEnd);
            }
            Boolean leftEqualRight = EqualEvaluator.equal(left, right, context);
            Boolean rightProperlyIncludesLeft = ProperIncludesEvaluator.properlyIncludes(right, left, precision, context);
            Boolean leftProperlyIncludesRight = ProperIncludesEvaluator.properlyIncludes(left, right, precision, context);
            Boolean rightStartsLeft = StartsEvaluator.starts(right, left, precision, context);
            Boolean rightEndsLeft = EndsEvaluator.ends(right, left, precision, context);
            Boolean isUndefined = AnyTrueEvaluator.anyTrue(Arrays.asList(leftEqualRight, rightProperlyIncludesLeft, AndEvaluator.and(leftProperlyIncludesRight, AndEvaluator.and(NotEvaluator.not(rightStartsLeft), NotEvaluator.not(rightEndsLeft)))));
            if (isUndefined != null && isUndefined.booleanValue()) {
                return null;
            }
            if (GreaterEvaluator.greater(rightStart, leftEnd, context).booleanValue()) {
                return left;
            }
            if (AndEvaluator.and(LessEvaluator.less(leftStart, rightStart, context), GreaterEvaluator.greater(leftEnd, rightEnd, context)).booleanValue()) {
                return null;
            }
            if (AndEvaluator.and(LessEvaluator.less(leftStart, rightStart, context), LessOrEqualEvaluator.lessOrEqual(leftEnd, rightEnd, context)).booleanValue()) {
                Object min = LessEvaluator.less(PredecessorEvaluator.predecessor(rightStart), leftEnd, context) != false ? PredecessorEvaluator.predecessor(rightStart) : leftEnd;
                return new Interval(leftStart, true, min, true);
            }
            if (AndEvaluator.and(GreaterEvaluator.greater(leftEnd, rightEnd, context), GreaterOrEqualEvaluator.greaterOrEqual(leftStart, rightStart, context)).booleanValue()) {
                Object max = GreaterEvaluator.greater(SuccessorEvaluator.successor(rightEnd), leftStart, context) != false ? SuccessorEvaluator.successor(rightEnd) : leftStart;
                return new Interval(max, true, leftEnd, true);
            }
            throw new UndefinedResult(String.format("The following interval values led to an undefined Except result: leftStart: %s, leftEnd: %s, rightStart: %s, rightEnd: %s", leftStart.toString(), leftEnd.toString(), rightStart.toString(), rightEnd.toString()));
        }
        if (left instanceof Iterable) {
            Iterable leftArr = (Iterable)left;
            Iterable rightArr = (Iterable)right;
            ArrayList result = new ArrayList();
            for (Object leftItem : leftArr) {
                Boolean in = InEvaluator.in(leftItem, rightArr, null, context);
                if (in == null || in.booleanValue()) continue;
                result.add(leftItem);
            }
            return DistinctEvaluator.distinct(result, context);
        }
        throw new InvalidOperatorArgument("Except(Interval<T>, Interval<T>) or Except(List<T>, List<T>)", String.format("Except(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return ExceptEvaluator.except(left, right, context);
    }
}

