/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Exp;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.UndefinedResult;
import org.opencds.cqf.cql.engine.execution.Context;

public class ExpEvaluator
extends Exp {
    public static Object exp(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof BigDecimal) {
            BigDecimal retVal;
            try {
                retVal = new BigDecimal(Math.exp(((BigDecimal)operand).doubleValue()));
            }
            catch (NumberFormatException nfe) {
                if (((BigDecimal)operand).compareTo(new BigDecimal(0)) > 0) {
                    throw new UndefinedResult("Results in positive infinity");
                }
                if (((BigDecimal)operand).compareTo(new BigDecimal(0)) < 0) {
                    throw new UndefinedResult("Results in negative infinity");
                }
                throw new UndefinedResult(nfe.getMessage());
            }
            return retVal;
        }
        throw new InvalidOperatorArgument("Exp(Decimal)", String.format("Exp(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ExpEvaluator.exp(operand);
    }
}

