/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.ArrayList;
import org.cqframework.cql.elm.execution.Expression;
import org.cqframework.cql.elm.execution.FunctionDef;
import org.cqframework.cql.elm.execution.FunctionRef;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.Variable;

public class FunctionRefEvaluator
extends FunctionRef {
    private FunctionDef cachedFunctionDef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object internalEvaluate(Context context) {
        ArrayList<Object> arguments = new ArrayList<Object>(this.getOperand().size());
        for (Expression operand : this.getOperand()) {
            arguments.add(operand.evaluate(context));
        }
        boolean enteredLibrary = context.enterLibrary(this.getLibraryName());
        try {
            FunctionDef functionDef = this.resolveOrCacheFunctionDef(context, arguments);
            if (Boolean.TRUE.equals(functionDef.isExternal())) {
                Object object = context.getExternalFunctionProvider().evaluate(this.cachedFunctionDef.getName(), arguments);
                return object;
            }
            context.pushWindow();
            try {
                for (int i = 0; i < arguments.size(); ++i) {
                    context.push(new Variable().withName(functionDef.getOperand().get(i).getName()).withValue(arguments.get(i)));
                }
                Object object = functionDef.getExpression().evaluate(context);
                context.popWindow();
                return object;
            }
            catch (Throwable throwable) {
                context.popWindow();
                throw throwable;
            }
        }
        finally {
            context.exitLibrary(enteredLibrary);
        }
    }

    protected FunctionDef resolveOrCacheFunctionDef(Context context, ArrayList<Object> arguments) {
        if (this.cachedFunctionDef == null && (arguments.isEmpty() || !this.getSignature().isEmpty())) {
            this.cachedFunctionDef = this.resolveFunctionDef(context, arguments);
        }
        return this.cachedFunctionDef != null ? this.cachedFunctionDef : this.resolveFunctionDef(context, arguments);
    }

    protected FunctionDef resolveFunctionDef(Context context, ArrayList<Object> arguments) {
        return context.resolveFunctionRef(this.getLibraryName(), this.getName(), arguments, this.getSignature());
    }
}

