/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.ValueSetRef;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.elm.executing.ValueSetRefEvaluator;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.ValueSet;

public class RetrieveEvaluator {
    public static Object internalEvaluate(Retrieve elm, State state, ElmLibraryVisitor<Object, State> visitor) {
        QName dataType = state.getEnvironment().fixupQName(elm.getDataType());
        DataProvider dataProvider = state.getEnvironment().resolveDataProvider(dataType);
        ArrayList<Code> codes = null;
        String valueSet = null;
        if (elm.getCodes() != null) {
            if (elm.getCodes() instanceof ValueSetRef) {
                ValueSet vs = ValueSetRefEvaluator.toValueSet(state, (ValueSetRef)elm.getCodes());
                valueSet = vs.getId();
            } else {
                ArrayList<Code> codesList;
                Object codesResult = visitor.visitExpression(elm.getCodes(), (Object)state);
                if (codesResult instanceof ValueSet) {
                    valueSet = ((ValueSet)codesResult).getId();
                } else if (codesResult instanceof String) {
                    codesList = new ArrayList<Code>();
                    codesList.add(new Code().withCode((String)codesResult));
                    codes = codesList;
                } else if (codesResult instanceof Code) {
                    codesList = new ArrayList();
                    codesList.add((Code)codesResult);
                    codes = codesList;
                } else if (codesResult instanceof Concept) {
                    codesList = new ArrayList();
                    for (Code conceptCode : ((Concept)codesResult).getCodes()) {
                        codesList.add(conceptCode);
                    }
                    codes = codesList;
                } else {
                    codes = (ArrayList<Code>)codesResult;
                }
            }
        }
        Interval dateRange = null;
        if (elm.getDateRange() != null) {
            dateRange = (Interval)visitor.visitExpression(elm.getDateRange(), (Object)state);
        }
        Iterable<Object> result = dataProvider.retrieve(state.getCurrentContext(), (String)dataProvider.getContextPath(state.getCurrentContext(), dataType.getLocalPart()), state.getCurrentContextValue(), dataType.getLocalPart(), elm.getTemplateId(), elm.getCodeProperty(), codes, valueSet, elm.getDateProperty(), elm.getDateLowProperty(), elm.getDateHighProperty(), dateRange);
        Set<Object> evaluatedResource = state.getEvaluatedResources();
        if (result instanceof List) {
            evaluatedResource.addAll((List)result);
        } else {
            for (Object o : result) {
                evaluatedResource.add(o);
            }
        }
        return result;
    }
}

