/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Library;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugLibraryResultEntry;
import org.opencds.cqf.cql.engine.debug.DebugUtilities;
import org.opencds.cqf.cql.engine.exception.CqlException;

public class DebugResult {
    private Map<String, DebugLibraryResultEntry> libraryResults = new HashMap<String, DebugLibraryResultEntry>();
    private ArrayList<CqlException> messages = new ArrayList();

    public void logDebugResult(Element node, Library currentLibrary, Object result, DebugAction action) {
        if (action == DebugAction.NONE) {
            return;
        }
        try {
            DebugLibraryResultEntry libraryResultEntry = this.libraryResults.get(currentLibrary.getIdentifier().getId());
            if (libraryResultEntry == null) {
                libraryResultEntry = new DebugLibraryResultEntry(currentLibrary.getIdentifier().getId());
                this.libraryResults.put(libraryResultEntry.getLibraryName(), libraryResultEntry);
            }
            if (libraryResultEntry != null) {
                libraryResultEntry.logDebugResultEntry(node, result);
            }
            if (action == DebugAction.LOG) {
                DebugUtilities.logDebugResult(node, currentLibrary, result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logDebugError(CqlException exception) {
        this.messages.add(exception);
    }

    public List<CqlException> getMessages() {
        return this.messages;
    }

    public Map<String, DebugLibraryResultEntry> getLibraryResults() {
        return this.libraryResults;
    }
}

