/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.TypeOverflow;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Value;

public class SuccessorEvaluator {
    public static Object successor(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            if ((Integer)value >= Value.MAX_INT) {
                throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Integer type");
            }
            return (Integer)value + 1;
        }
        if (value instanceof Long) {
            if ((Long)value >= Value.MAX_LONG) {
                throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Long type");
            }
            return (Long)value + 1L;
        }
        if (value instanceof BigDecimal) {
            if (((BigDecimal)value).compareTo(Value.MAX_DECIMAL) >= 0) {
                throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Decimal type");
            }
            return ((BigDecimal)value).add(new BigDecimal("0.00000001"));
        }
        if (value instanceof Quantity) {
            if (((Quantity)value).getValue().compareTo(Value.MAX_DECIMAL) >= 0) {
                throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Decimal type");
            }
            Quantity quantity = (Quantity)value;
            return new Quantity().withValue((BigDecimal)SuccessorEvaluator.successor(quantity.getValue())).withUnit(quantity.getUnit());
        }
        if (value instanceof Date) {
            Date dt = (Date)value;
            return new Date(dt.getDate().plus(1L, dt.getPrecision().toChronoUnit()), dt.getPrecision());
        }
        if (value instanceof DateTime) {
            DateTime dt = (DateTime)value;
            return new DateTime(dt.getDateTime().plus(1L, dt.getPrecision().toChronoUnit()), dt.getPrecision());
        }
        if (value instanceof Time) {
            Time t = (Time)value;
            switch (t.getPrecision()) {
                case HOUR: {
                    if (t.getTime().getHour() != 23) break;
                    throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Time type");
                }
                case MINUTE: {
                    if (t.getTime().getHour() != 23 || t.getTime().getMinute() != 23) break;
                    throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Time type");
                }
                case SECOND: {
                    if (t.getTime().getHour() != 23 || t.getTime().getMinute() != 23 || t.getTime().getSecond() != 59) break;
                    throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Time type");
                }
                case MILLISECOND: {
                    if (t.getTime().getHour() != 23 || t.getTime().getMinute() != 59 || t.getTime().getSecond() != 59 || t.getTime().get(Precision.MILLISECOND.toChronoField()) != 999) break;
                    throw new TypeOverflow("The result of the successor operation exceeds the maximum value allowed for the Time type");
                }
            }
            return new Time(t.getTime().plus(1L, t.getPrecision().toChronoUnit()), t.getPrecision());
        }
        throw new InvalidOperatorArgument(String.format("The Successor operation is not implemented for type %s", value.getClass().getName()));
    }
}

