/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.stream.StreamSupport;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.Length;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;

public class LengthEvaluator {
    public static Object length(Object operand) {
        if (operand instanceof String) {
            return LengthEvaluator.stringLength((String)operand);
        }
        if (operand instanceof Iterable) {
            return LengthEvaluator.listLength((Iterable)operand);
        }
        throw new InvalidOperatorArgument("Length(List<T>) or Length(String)", String.format("Length(%s)", operand.getClass().getName()));
    }

    public static Integer stringLength(String operand) {
        if (operand == null) {
            return null;
        }
        return operand.length();
    }

    public static Integer listLength(Iterable<?> operand) {
        if (operand == null) {
            return 0;
        }
        return (int)StreamSupport.stream(operand.spliterator(), false).count();
    }

    public static Object internalEvaluate(Object operand, Length length, State state) {
        if (length.getOperand() instanceof As) {
            if (((As)length.getOperand()).getAsTypeSpecifier() instanceof NamedTypeSpecifier) {
                return LengthEvaluator.stringLength((String)operand);
            }
            return LengthEvaluator.listLength((Iterable)operand);
        }
        return LengthEvaluator.length(operand);
    }
}

