/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.ArrayList;
import java.util.Arrays;
import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EndsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NotEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PredecessorEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProperIncludesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.StartsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.UndefinedResult;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class ExceptEvaluator {
    public static Object except(Object left, Object right, State state) {
        if (left == null) {
            return null;
        }
        if (!(left instanceof Iterable) && right == null) {
            return null;
        }
        if (left instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart == null || leftEnd == null || rightStart == null || rightEnd == null) {
                return null;
            }
            String precision = null;
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)leftEnd, (BaseTemporal)rightStart, (BaseTemporal)rightEnd);
            }
            Boolean leftEqualRight = EqualEvaluator.equal(left, right, state);
            Boolean rightProperlyIncludesLeft = ProperIncludesEvaluator.properlyIncludes(right, left, precision, state);
            Boolean leftProperlyIncludesRight = ProperIncludesEvaluator.properlyIncludes(left, right, precision, state);
            Boolean rightStartsLeft = StartsEvaluator.starts(right, left, precision, state);
            Boolean rightEndsLeft = EndsEvaluator.ends(right, left, precision, state);
            Boolean isUndefined = AnyTrueEvaluator.anyTrue(Arrays.asList(leftEqualRight, rightProperlyIncludesLeft, AndEvaluator.and(leftProperlyIncludesRight, AndEvaluator.and(NotEvaluator.not(rightStartsLeft), NotEvaluator.not(rightEndsLeft)))));
            if (isUndefined != null && isUndefined.booleanValue()) {
                return null;
            }
            if (GreaterEvaluator.greater(rightStart, leftEnd, state).booleanValue()) {
                return left;
            }
            if (AndEvaluator.and(LessEvaluator.less(leftStart, rightStart, state), GreaterEvaluator.greater(leftEnd, rightEnd, state)).booleanValue()) {
                return null;
            }
            if (AndEvaluator.and(LessEvaluator.less(leftStart, rightStart, state), LessOrEqualEvaluator.lessOrEqual(leftEnd, rightEnd, state)).booleanValue()) {
                Object min = LessEvaluator.less(PredecessorEvaluator.predecessor(rightStart), leftEnd, state) != false ? PredecessorEvaluator.predecessor(rightStart) : leftEnd;
                return new Interval(leftStart, true, min, true);
            }
            if (AndEvaluator.and(GreaterEvaluator.greater(leftEnd, rightEnd, state), GreaterOrEqualEvaluator.greaterOrEqual(leftStart, rightStart, state)).booleanValue()) {
                Object max = GreaterEvaluator.greater(SuccessorEvaluator.successor(rightEnd), leftStart, state) != false ? SuccessorEvaluator.successor(rightEnd) : leftStart;
                return new Interval(max, true, leftEnd, true);
            }
            throw new UndefinedResult(String.format("The following interval values led to an undefined Except result: leftStart: %s, leftEnd: %s, rightStart: %s, rightEnd: %s", leftStart.toString(), leftEnd.toString(), rightStart.toString(), rightEnd.toString()));
        }
        if (left instanceof Iterable) {
            Iterable leftArr = (Iterable)left;
            Iterable rightArr = (Iterable)right;
            ArrayList result = new ArrayList();
            for (Object leftItem : leftArr) {
                Boolean in = InEvaluator.in(leftItem, rightArr, null, state);
                if (in == null || in.booleanValue()) continue;
                result.add(leftItem);
            }
            return DistinctEvaluator.distinct(result, state);
        }
        throw new InvalidOperatorArgument("Except(Interval<T>, Interval<T>) or Except(List<T>, List<T>)", String.format("Except(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

