/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.execution.State;

public class ExpressionDefEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internalEvaluate(ExpressionDef expressionDef, State state, ElmLibraryVisitor<Object, State> visitor) {
        if (expressionDef.getContext() != null) {
            state.enterContext(expressionDef.getContext());
        }
        try {
            state.pushEvaluatedResourceStack();
            VersionedIdentifier libraryId = state.getCurrentLibrary().getIdentifier();
            if (state.getCache().isExpressionCachingEnabled() && state.getCache().isExpressionCached(libraryId, expressionDef.getName())) {
                ExpressionResult er = state.getCache().getCachedExpression(libraryId, expressionDef.getName());
                state.getEvaluatedResources().addAll(er.evaluatedResources());
                Object object = er.value();
                return object;
            }
            Object value = visitor.visitExpression(expressionDef.getExpression(), (Object)state);
            if (state.getCache().isExpressionCachingEnabled()) {
                ExpressionResult er = new ExpressionResult(value, state.getEvaluatedResources());
                state.getCache().cacheExpression(libraryId, expressionDef.getName(), er);
            }
            Object object = value;
            return object;
        }
        finally {
            state.popEvaluatedResourceStack();
            if (expressionDef.getContext() != null) {
                state.exitContext();
            }
        }
    }
}

