/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime.iterators;

import java.util.ArrayList;
import java.util.Iterator;

public class ResetIterator<E>
implements Iterator<E> {
    private Iterator<E> source;
    private ArrayList<E> data = new ArrayList();
    int dataIndex = -1;
    private boolean dataCached = false;

    public ResetIterator(Iterator<E> source) {
        this.source = source;
        this.data = new ArrayList();
    }

    @Override
    public boolean hasNext() {
        if (!this.dataCached) {
            return this.source.hasNext();
        }
        return this.dataIndex < this.data.size() - 1 && this.data.size() > 0;
    }

    @Override
    public E next() {
        if (!this.dataCached) {
            E element = this.source.next();
            this.data.add(element);
            return element;
        }
        ++this.dataIndex;
        return this.data.get(this.dataIndex);
    }

    public void reset() {
        while (this.source.hasNext()) {
            this.data.add(this.source.next());
        }
        this.dataCached = true;
        this.dataIndex = -1;
    }
}

