/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class MeetsBeforeEvaluator {
    public static Boolean meetsBefore(Object left, Object right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Boolean isLeftStartGreater = GreaterEvaluator.greater(((Interval)left).getStart(), ((Interval)right).getEnd(), state);
            if (isLeftStartGreater != null && isLeftStartGreater.booleanValue()) {
                return false;
            }
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Boolean isIn = InEvaluator.in(leftEnd, right, precision, state);
            if (isIn != null && isIn.booleanValue()) {
                return false;
            }
            isIn = InEvaluator.in(((Interval)left).getStart(), right, precision, state);
            if (isIn != null && isIn.booleanValue()) {
                return false;
            }
            isIn = InEvaluator.in(leftEnd, right, precision, state);
            if (isIn != null && isIn.booleanValue()) {
                return false;
            }
            return MeetsEvaluator.meetsOperation(leftEnd, rightStart, precision, state);
        }
        throw new InvalidOperatorArgument("MeetsBefore(Interval<T>, Interval<T>)", String.format("MeetsBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

