/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.CqlType;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class EqualEvaluator {
    public static Boolean equal(Object left, Object right, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Integer) {
            return ((Interval)left).equal(right);
        }
        if (right instanceof Interval && left instanceof Integer) {
            return ((Interval)right).equal(left);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return CqlList.equal((Iterable)left, (Iterable)right, state);
        }
        if (!left.getClass().equals(right.getClass())) {
            return false;
        }
        if (left instanceof Boolean || left instanceof Integer || left instanceof Long || left instanceof String) {
            return left.equals(right);
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).compareTo((BigDecimal)right) == 0;
        }
        if (left instanceof CqlType && right instanceof CqlType) {
            return ((CqlType)left).equal(right);
        }
        if (state != null) {
            return state.getEnvironment().objectEqual(left, right);
        }
        throw new InvalidOperatorArgument(String.format("Equal(%s, %s) requires Context and state was null", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean equal(Object left, Object right) {
        return EqualEvaluator.equal(left, right, null);
    }
}

