/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.opencds.cqf.cql.engine.elm.executing.AddEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CollapseEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DurationBetweenEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PredecessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class ExpandEvaluator {
    private static Object addPer(Object addTo, Quantity per) {
        if (addTo instanceof Integer) {
            return AddEvaluator.add(addTo, per.getValue().intValue());
        }
        if (addTo instanceof BigDecimal) {
            return AddEvaluator.add(addTo, per.getValue());
        }
        if (addTo instanceof Quantity) {
            return AddEvaluator.add(addTo, per);
        }
        throw new InvalidOperatorArgument("Expand(List<Interval<T>>, Quantity)", String.format("Expand(%s, %s)", addTo.getClass().getName(), per.getClass().getName()));
    }

    public static List<Interval> getExpandedInterval(Interval interval, Quantity per, State state) {
        if (interval.getLow() == null || interval.getHigh() == null) {
            return null;
        }
        ArrayList<Interval> expansion = new ArrayList<Interval>();
        Object start = interval.getStart();
        Object end = ExpandEvaluator.addPer(start, per);
        if ((start instanceof Integer || start instanceof BigDecimal) && !per.getUnit().equals("1")) {
            return null;
        }
        if (EqualEvaluator.equal(start, interval.getEnd(), state).booleanValue()) {
            expansion.add(new Interval(start, true, start, true));
            return expansion;
        }
        while (LessOrEqualEvaluator.lessOrEqual(PredecessorEvaluator.predecessor(end), interval.getEnd(), state).booleanValue()) {
            expansion.add(new Interval(start, true, end, false));
            start = end;
            end = ExpandEvaluator.addPer(start, per);
        }
        return expansion;
    }

    public static List<Interval> getExpandedInterval(Interval interval, Quantity per, String precision) {
        Object i;
        if (interval.getLow() == null || interval.getHigh() == null) {
            return null;
        }
        try {
            i = DurationBetweenEvaluator.duration(interval.getStart(), interval.getEnd(), Precision.fromString(precision));
        }
        catch (Exception e) {
            return null;
        }
        if (i instanceof Integer) {
            ArrayList<Interval> expansion = new ArrayList<Interval>();
            Interval unit = null;
            Object start = interval.getStart();
            Object end = AddEvaluator.add(start, per);
            for (int j = 0; j < (Integer)i; ++j) {
                unit = new Interval(start, true, end, false);
                expansion.add(unit);
                start = end;
                end = AddEvaluator.add(start, per);
            }
            if (unit != null) {
                i = DurationBetweenEvaluator.duration(unit.getEnd(), interval.getEnd(), Precision.fromString(precision));
                if (i instanceof Integer && (Integer)i == 1) {
                    expansion.add(new Interval(start, true, end, false));
                }
            } else if (((BaseTemporal)start).getPrecision() == Precision.fromString(precision) && ((BaseTemporal)end).getPrecision() == Precision.fromString(precision)) {
                expansion.add(new Interval(start, true, end, false));
            }
            return expansion;
        }
        return null;
    }

    public static List<Interval> expand(Iterable<Interval> list, Quantity per, State state) {
        if (list == null) {
            return null;
        }
        List<Interval> intervals = CqlList.toList(list, false);
        if (intervals.isEmpty()) {
            return intervals;
        }
        intervals = CollapseEvaluator.collapse(intervals, new Quantity().withValue(BigDecimal.ZERO).withUnit(per == null ? "1" : per.getUnit()), state);
        boolean isTemporal = intervals.get(0).getStart() instanceof BaseTemporal || intervals.get(0).getEnd() instanceof BaseTemporal;
        intervals.sort(new CqlList().valueSort);
        if (per == null) {
            per = isTemporal ? new Quantity().withValue(new BigDecimal("1.0")).withUnit(BaseTemporal.getLowestPrecision((BaseTemporal)intervals.get(0).getStart(), (BaseTemporal)intervals.get(0).getEnd())) : new Quantity().withValue(new BigDecimal("1.0")).withDefaultUnit();
        }
        String precision = per.getUnit().equals("1") ? null : per.getUnit();
        TreeSet<Interval> set = new TreeSet<Interval>();
        for (Interval interval : intervals) {
            List<Interval> temp;
            if (interval == null) continue;
            List<Interval> list2 = temp = isTemporal ? ExpandEvaluator.getExpandedInterval(interval, per, precision) : ExpandEvaluator.getExpandedInterval(interval, per, state);
            if (temp == null) {
                return null;
            }
            if (temp.isEmpty()) continue;
            set.addAll(temp);
        }
        return set.isEmpty() ? new ArrayList<Interval>() : new ArrayList(set);
    }
}

