/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MaxValueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsBeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OrEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class MeetsEvaluator {
    public static Boolean meetsOperation(Object left, Object right, String precision, State state) {
        Boolean isMax;
        if (left == null && right == null) {
            return null;
        }
        Object maxValue = MaxValueEvaluator.maxValue(left != null ? left.getClass().getName() : right.getClass().getName());
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            isMax = SameAsEvaluator.sameAs(left, maxValue, precision, state);
            if (isMax != null && isMax.booleanValue()) {
                return false;
            }
            String tempPrecision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
            if (precision == null && ((BaseTemporal)left).isUncertain(Precision.fromString(tempPrecision))) {
                return SameAsEvaluator.sameAs(SuccessorEvaluator.successor(left), right, tempPrecision, state);
            }
            if (precision != null && ((BaseTemporal)left).isUncertain(Precision.fromString(precision))) {
                return SameAsEvaluator.sameAs(left, right, precision, state);
            }
            if (precision == null) {
                precision = tempPrecision;
            }
            if (left instanceof DateTime && right instanceof DateTime) {
                DateTime dt = new DateTime(((DateTime)left).getDateTime().plus(1L, Precision.fromString(precision).toChronoUnit()), ((BaseTemporal)left).getPrecision());
                return SameAsEvaluator.sameAs(dt, right, precision, state);
            }
            if (left instanceof Time) {
                Time t = new Time(((Time)left).getTime().plus(1L, Precision.fromString(precision).toChronoUnit()), ((BaseTemporal)left).getPrecision());
                return SameAsEvaluator.sameAs(t, right, precision, state);
            }
        }
        if ((isMax = EqualEvaluator.equal(left, maxValue, state)) != null && isMax.booleanValue()) {
            return false;
        }
        return EqualEvaluator.equal(SuccessorEvaluator.successor(left), right, state);
    }

    public static Boolean meets(Object left, Object right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Boolean in = InEvaluator.in(leftStart, right, precision, state);
            if (in != null && in.booleanValue()) {
                return false;
            }
            in = InEvaluator.in(leftEnd, right, precision, state);
            if (in != null && in.booleanValue()) {
                return false;
            }
            return OrEvaluator.or(MeetsBeforeEvaluator.meetsBefore(left, right, precision, state), MeetsAfterEvaluator.meetsAfter(left, right, precision, state));
        }
        throw new InvalidOperatorArgument("Meets(Interval<T>, Interval<T>)", String.format("Meets(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

