/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.elm.r1.Element;
import org.opencds.cqf.cql.engine.debug.DebugLocator;
import org.opencds.cqf.cql.engine.debug.DebugResultEntry;
import org.opencds.cqf.cql.engine.debug.Location;

public class DebugLibraryResultEntry {
    private String libraryName;
    private Map<DebugLocator, List<DebugResultEntry>> results;

    public String getLibraryName() {
        return this.libraryName;
    }

    public DebugLibraryResultEntry(String libraryName) {
        this.libraryName = libraryName;
        this.results = new HashMap<DebugLocator, List<DebugResultEntry>>();
    }

    public Map<DebugLocator, List<DebugResultEntry>> getResults() {
        return this.results;
    }

    private void logDebugResult(DebugLocator locator, Object result) {
        if (!this.results.containsKey(locator)) {
            this.results.put(locator, new ArrayList());
        }
        List<DebugResultEntry> debugResults = this.results.get(locator);
        debugResults.add(new DebugResultEntry(result));
    }

    public void logDebugResultEntry(Element node, Object result) {
        DebugLocator locator;
        Objects.requireNonNull(node, "node cannot be null");
        if (node.getLocalId() != null) {
            locator = new DebugLocator(DebugLocator.DebugLocatorType.NODE_ID, node.getLocalId());
            this.logDebugResult(locator, result);
        }
        if (node.getLocator() != null) {
            locator = new DebugLocator(Location.fromLocator(node.getLocator()));
            this.logDebugResult(locator, result);
        }
    }
}

