/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Library;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugLibraryResultEntry;
import org.opencds.cqf.cql.engine.debug.DebugUtilities;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.execution.Profile;

public class DebugResult {
    private final Map<String, DebugLibraryResultEntry> libraryResults = new HashMap<String, DebugLibraryResultEntry>();
    private final ArrayList<CqlException> messages = new ArrayList();
    private Profile profile = null;

    public void logDebugResult(Element node, Library currentLibrary, Object result, DebugAction action) {
        if (action == DebugAction.NONE) {
            return;
        }
        try {
            DebugLibraryResultEntry libraryResultEntry = this.libraryResults.get(currentLibrary.getIdentifier().getId());
            if (libraryResultEntry == null) {
                libraryResultEntry = new DebugLibraryResultEntry(currentLibrary.getIdentifier().getId());
                this.libraryResults.put(libraryResultEntry.getLibraryName(), libraryResultEntry);
            }
            libraryResultEntry.logDebugResultEntry(node, result);
            if (action == DebugAction.LOG) {
                DebugUtilities.logDebugResult(node, currentLibrary, result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logDebugError(CqlException exception) {
        this.messages.add(exception);
    }

    public List<CqlException> getMessages() {
        return this.messages;
    }

    public Map<String, DebugLibraryResultEntry> getLibraryResults() {
        return this.libraryResults;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public Profile ensureProfile() {
        if (this.profile == null) {
            this.profile = new Profile();
        }
        return this.profile;
    }
}

