/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Library;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtilities {
    private static final Logger logger = LoggerFactory.getLogger(DebugUtilities.class);

    private DebugUtilities() {
    }

    public static void logDebugResult(Element node, Library currentLibrary, Object result) {
        String debugLocation = DebugUtilities.toDebugLocation(node);
        String debugString = DebugUtilities.toDebugString(result);
        logger.debug("{}.{}: {}", new Object[]{currentLibrary != null ? currentLibrary.getIdentifier().getId() : "unknown", debugLocation, debugString});
    }

    public static String toDebugLocation(Element node) {
        Object result = "";
        if (node.getLocator() != null) {
            result = node.getLocator();
        }
        if (node.getLocalId() != null) {
            result = (String)result + "(" + node.getLocalId() + ")";
        }
        return result;
    }

    public static String toDebugString(Object result) {
        if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            return "{" + StreamSupport.stream(iterable.spliterator(), false).map(DebugUtilities::toDebugString).collect(Collectors.joining(",")) + "}";
        }
        if (result != null) {
            return result.toString();
        }
        return "<null>";
    }
}

