/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencds.cqf.cql.engine.elm.executing.AddEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CollapseEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PredecessorEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.IntervalHelper;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class ExpandEvaluator {
    private static Object addPer(Object addTo, Quantity per) {
        if (addTo instanceof Integer) {
            return AddEvaluator.add(addTo, per.getValue().setScale(0, RoundingMode.CEILING).intValue());
        }
        if (addTo instanceof Long) {
            return AddEvaluator.add(addTo, per.getValue().setScale(0, RoundingMode.CEILING).longValue());
        }
        if (addTo instanceof BigDecimal) {
            return AddEvaluator.add(addTo, per.getValue());
        }
        if (addTo instanceof Quantity) {
            return AddEvaluator.add(addTo, per);
        }
        if (addTo instanceof BaseTemporal) {
            return AddEvaluator.add(addTo, per);
        }
        throw new InvalidOperatorArgument("Expand(List<Interval<T>>, Quantity), Expand(Interval<T>, Quantity)", String.format("Expand(%s, %s)", addTo.getClass().getName(), per.getClass().getName()));
    }

    private static List<Interval> expandIntervalIntoIntervals(Interval interval, Quantity per, State state) {
        Object nextStart;
        Object start = interval.getStart();
        if (!Boolean.TRUE.equals(LessEvaluator.less(start, nextStart = ExpandEvaluator.addPer(start, per), state))) {
            return null;
        }
        ArrayList<Interval> returnedIntervals = new ArrayList<Interval>();
        Object endSuccessor = SuccessorEvaluator.successor(interval.getEnd(), per);
        while (true) {
            Boolean lessOrEqual;
            if ((lessOrEqual = LessOrEqualEvaluator.lessOrEqual(nextStart, endSuccessor, state)) == null) {
                return null;
            }
            if (!lessOrEqual.booleanValue()) break;
            returnedIntervals.add(new Interval(start, true, PredecessorEvaluator.predecessor(nextStart, per), true));
            start = nextStart;
            nextStart = ExpandEvaluator.addPer(start, per);
        }
        return returnedIntervals;
    }

    private static List<Object> expandIntervalIntoPoints(Interval interval, Quantity per, State state) {
        List<Interval> returnedIntervals = ExpandEvaluator.expandIntervalsIntoIntervals(Collections.singletonList(interval), per, state);
        if (returnedIntervals == null) {
            return null;
        }
        return returnedIntervals.stream().map(Interval::getStart).collect(Collectors.toList());
    }

    private static List<Interval> prepareIntervals(List<Interval> intervals, Quantity per, State state) {
        intervals = intervals.stream().filter(interval -> interval.getLow() != null && interval.getHigh() != null).map(interval -> IntervalHelper.truncateIntervalBoundaries(interval, per, state)).filter(Objects::nonNull).collect(Collectors.toList());
        if ((intervals = CollapseEvaluator.collapse(intervals, new Quantity().withValue(BigDecimal.ZERO).withUnit(per.getUnit()), state)) == null) {
            return null;
        }
        intervals.sort(new CqlList().valueSort);
        return intervals;
    }

    private static List<Interval> expandIntervalsIntoIntervals(Iterable<Interval> list, Quantity per, State state) {
        Quantity perOrDefault;
        List<Interval> intervals = CqlList.toList(list, false);
        if (intervals.isEmpty()) {
            return intervals;
        }
        Quantity quantity = perOrDefault = per == null ? IntervalHelper.quantityFromCoarsestPrecisionOfBoundaries(intervals) : per;
        if (!IntervalHelper.isQuantityCompatibleWithBoundaries(perOrDefault, intervals)) {
            return null;
        }
        if ((intervals = ExpandEvaluator.prepareIntervals(intervals, perOrDefault, state)) == null) {
            return null;
        }
        return intervals.stream().filter(Objects::nonNull).flatMap(interval -> {
            List<Interval> returnedIntervals = ExpandEvaluator.expandIntervalIntoIntervals(interval, perOrDefault, state);
            return returnedIntervals == null ? Stream.empty() : returnedIntervals.stream();
        }).collect(Collectors.toList());
    }

    public static Object expand(Object listOrInterval, Quantity per, State state) {
        if (listOrInterval == null) {
            return null;
        }
        if (listOrInterval instanceof Interval) {
            return ExpandEvaluator.expandIntervalIntoPoints((Interval)listOrInterval, per, state);
        }
        if (listOrInterval instanceof Iterable) {
            Iterable list = (Iterable)listOrInterval;
            return ExpandEvaluator.expandIntervalsIntoIntervals(list, per, state);
        }
        throw new InvalidOperatorArgument("Expand(List<Interval<T>>, Quantity), Expand(Interval<T>, Quantity)", String.format("Expand(%s, %s)", listOrInterval.getClass().getName(), per.getClass().getName()));
    }
}

