/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.execution.State;

public class ExpressionDefEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internalEvaluate(ExpressionDef expressionDef, State state, ElmLibraryVisitor<Object, State> visitor) {
        boolean isEnteredContext = false;
        if (expressionDef.getContext() != null) {
            isEnteredContext = state.enterContext(expressionDef.getContext());
        }
        try {
            state.pushEvaluatedResourceStack();
            VersionedIdentifier libraryId = state.getCurrentLibrary().getIdentifier();
            boolean isExpressionCachingEnabled = state.getCache().isExpressionCachingEnabled();
            boolean isExpressionCached = state.getCache().isExpressionCached(libraryId, expressionDef.getName());
            if (isExpressionCachingEnabled && isExpressionCached) {
                ExpressionResult er = state.getCache().getCachedExpression(libraryId, expressionDef.getName());
                state.getEvaluatedResources().addAll(er.evaluatedResources());
                State.ActivationFrame frame = state.getTopActivationFrame();
                assert (frame.element == expressionDef);
                frame.isCached = true;
                Object object = er.value();
                return object;
            }
            Object value = visitor.visitExpression(expressionDef.getExpression(), (Object)state);
            if (state.getCache().isExpressionCachingEnabled()) {
                ExpressionResult er = new ExpressionResult(value, state.getEvaluatedResources());
                state.getCache().cacheExpression(libraryId, expressionDef.getName(), er);
            }
            Object object = value;
            return object;
        }
        finally {
            state.popEvaluatedResourceStack();
            state.exitContext(isEnteredContext);
        }
    }
}

