/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.State;

public class ExpressionRefEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internalEvaluate(ExpressionRef expressionRef, State state, ElmLibraryVisitor<Object, State> visitor) {
        boolean enteredLibrary = state.enterLibrary(expressionRef.getLibraryName());
        try {
            ExpressionDef def = Libraries.resolveExpressionRef(expressionRef.getName(), state.getCurrentLibrary());
            state.pushActivationFrame((Element)def, def.getContext());
            try {
                Object object = visitor.visitExpressionDef(def, (Object)state);
                state.popActivationFrame();
                return object;
            }
            catch (Throwable throwable) {
                state.popActivationFrame();
                throw throwable;
            }
        }
        finally {
            state.exitLibrary(enteredLibrary);
        }
    }
}

