/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import org.cqframework.cql.elm.evaluating.SimpleElmEvaluator;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.TypeSpecifier;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRefEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(FunctionRefEvaluator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internalEvaluate(FunctionRef functionRef, State state, ElmLibraryVisitor<Object, State> visitor) {
        ArrayList<Object> arguments = new ArrayList<Object>(functionRef.getOperand().size());
        for (Expression operand : functionRef.getOperand()) {
            arguments.add(visitor.visitExpression(operand, (Object)state));
        }
        boolean enteredLibrary = state.enterLibrary(functionRef.getLibraryName());
        try {
            FunctionDef functionDef = FunctionRefEvaluator.resolveOrCacheFunctionDef(state, functionRef, arguments);
            if (Boolean.TRUE.equals(functionDef.isExternal())) {
                Object object = state.getEnvironment().getExternalFunctionProvider(state.getCurrentLibrary().getIdentifier()).evaluate(functionDef.getName(), arguments);
                return object;
            }
            state.pushActivationFrame((Element)functionDef, functionDef.getContext());
            try {
                for (int i = 0; i < arguments.size(); ++i) {
                    state.push(new Variable(((OperandDef)functionDef.getOperand().get(i)).getName()).withValue(arguments.get(i)));
                }
                Object object = visitor.visitExpression(functionDef.getExpression(), (Object)state);
                state.popActivationFrame();
                return object;
            }
            catch (Throwable throwable) {
                state.popActivationFrame();
                throw throwable;
            }
        }
        finally {
            state.exitLibrary(enteredLibrary);
        }
    }

    protected static FunctionDef resolveOrCacheFunctionDef(State state, FunctionRef functionRef, ArrayList<Object> arguments) {
        boolean eligibleForCaching = false;
        if (!functionRef.getSignature().isEmpty() || arguments.isEmpty()) {
            eligibleForCaching = true;
            if (state.getCache().getFunctionCache().containsKey(functionRef)) {
                return state.getCache().getFunctionCache().get(functionRef);
            }
        }
        FunctionDef functionDef = FunctionRefEvaluator.resolveFunctionRef(state, functionRef, arguments);
        if (eligibleForCaching) {
            state.getCache().getFunctionCache().put(functionRef, functionDef);
        }
        return functionDef;
    }

    protected static FunctionDef resolveFunctionRef(State state, FunctionRef functionRef, List<Object> arguments) {
        String name = functionRef.getName();
        List signature = functionRef.getSignature();
        List<FunctionDef> functionDefs = FunctionRefEvaluator.resolveFunctionRef(state, name, arguments, signature);
        return FunctionRefEvaluator.pickFunctionDef(state, name, arguments, signature, functionDefs);
    }

    static List<FunctionDef> resolveFunctionRef(State state, String name, List<Object> arguments, List<TypeSpecifier> signature) {
        List<FunctionDef> namedDefs = Libraries.getFunctionDefs(name, state.getCurrentLibrary());
        if (!signature.isEmpty()) {
            return namedDefs.stream().filter(x -> FunctionRefEvaluator.functionDefOperandsSignatureEqual(x, signature)).collect(Collectors.toList());
        }
        logger.debug("Using runtime function resolution for '{}'. It's recommended to always include signatures in ELM", (Object)name);
        return namedDefs.stream().filter(x -> state.getEnvironment().matchesTypes((FunctionDef)x, (List<? extends Object>)arguments)).collect(Collectors.toList());
    }

    static boolean functionDefOperandsSignatureEqual(FunctionDef functionDef, List<TypeSpecifier> signature) {
        List operands = functionDef.getOperand();
        return operands.size() == signature.size() && IntStream.range(0, operands.size()).allMatch(i -> FunctionRefEvaluator.operandDefTypeSpecifierEqual((OperandDef)operands.get(i), (TypeSpecifier)signature.get(i)));
    }

    static boolean operandDefTypeSpecifierEqual(OperandDef operandDef, TypeSpecifier typeSpecifier) {
        TypeSpecifier operandDefOperandTypeSpecifier = operandDef.getOperandTypeSpecifier();
        if (operandDefOperandTypeSpecifier != null) {
            return SimpleElmEvaluator.typeSpecifiersEqual((TypeSpecifier)operandDefOperandTypeSpecifier, (TypeSpecifier)typeSpecifier);
        }
        if (typeSpecifier instanceof NamedTypeSpecifier) {
            return SimpleElmEvaluator.qnamesEqual((QName)operandDef.getOperandType(), (QName)((NamedTypeSpecifier)typeSpecifier).getName());
        }
        return false;
    }

    static FunctionDef pickFunctionDef(State state, String name, List<Object> arguments, List<TypeSpecifier> signature, List<FunctionDef> functionDefs) {
        List<Object> types;
        List<Object> list = types = signature.isEmpty() ? arguments : signature;
        if (functionDefs.isEmpty()) {
            throw new CqlException(String.format("Could not resolve call to operator '%s(%s)' in library '%s'.", name, FunctionRefEvaluator.typesToString(state, types), state.getCurrentLibrary().getIdentifier().getId()));
        }
        if (functionDefs.size() == 1) {
            return functionDefs.get(0);
        }
        throw new CqlException(String.format("Ambiguous call to operator '%s(%s)' in library '%s'.", name, FunctionRefEvaluator.typesToString(state, types), state.getCurrentLibrary().getIdentifier().getId()));
    }

    static String typesToString(State state, List<? extends Object> arguments) {
        StringBuilder argStr = new StringBuilder();
        if (arguments != null) {
            arguments.forEach(a -> {
                argStr.append(argStr.length() > 0 ? ", " : "");
                Class<?> type = state.getEnvironment().resolveType(a);
                argStr.append(type == null ? "null" : type.getTypeName());
            });
        }
        return argStr.toString();
    }
}

