/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.ValueSet;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class InValueSetEvaluator {
    public static Object inValueSet(Object code, Object valueset, State state) {
        if (code == null) {
            return false;
        }
        if (valueset == null) {
            return null;
        }
        if (valueset instanceof ValueSet) {
            ValueSetInfo vsi = ValueSetInfo.fromValueSet((ValueSet)valueset);
            TerminologyProvider provider = state.getEnvironment().getTerminologyProvider();
            if (code instanceof String) {
                if (provider.in(new Code().withCode((String)code), vsi)) {
                    return true;
                }
                return false;
            }
            if (code instanceof Code) {
                if (provider.in((Code)code, vsi)) {
                    return true;
                }
                return false;
            }
            if (code instanceof Concept) {
                for (Code codes : ((Concept)code).getCodes()) {
                    if (codes == null) {
                        return null;
                    }
                    if (!provider.in(codes, vsi)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new InvalidOperatorArgument("In(String, ValueSetRef), In(Code, ValueSetRef) or In(Concept, ValueSetRef)", String.format("In(%s, %s)", code.getClass().getName(), valueset.getClass().getName()));
    }
}

