/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.elm.executing.MultiplyEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class ProductEvaluator {
    public static Object product(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Object result = null;
            for (Object element : (Iterable)source) {
                if (element == null) {
                    return null;
                }
                if (result == null) {
                    result = element;
                    continue;
                }
                if (element instanceof Integer && result instanceof Integer || element instanceof Long && result instanceof Long || element instanceof BigDecimal && result instanceof BigDecimal) {
                    result = MultiplyEvaluator.multiply(result, element);
                    continue;
                }
                if (element instanceof Quantity && result instanceof Quantity) {
                    if (!((Quantity)element).getUnit().equals(((Quantity)result).getUnit())) {
                        throw new IllegalArgumentException(String.format("Found different units during Quantity product evaluation: %s and %s", ((Quantity)element).getUnit(), ((Quantity)result).getUnit()));
                    }
                    ((Quantity)result).setValue((BigDecimal)MultiplyEvaluator.multiply(((Quantity)result).getValue(), ((Quantity)element).getValue()));
                    continue;
                }
                throw new InvalidOperatorArgument("Product(List<Integer>), Product(List<Long>), Product(List<Decimal>) or Product(List<Quantity>)", String.format("Product(List<%s>)", element.getClass().getName()));
            }
            return result;
        }
        throw new InvalidOperatorArgument("Product(List<Integer>), Product(List<Long>), Product(List<Decimal>) or Product(List<Quantity>)", String.format("Product(%s)", source.getClass().getName()));
    }
}

