/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.List;
import org.opencds.cqf.cql.engine.elm.executing.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class ProperContainsEvaluator {
    public static Boolean properContains(Object left, Object right, State state) {
        if (left == null) {
            return false;
        }
        if (left instanceof Interval) {
            Boolean startProperContains = GreaterEvaluator.greater(right, ((Interval)left).getStart(), state);
            Boolean endProperContains = LessEvaluator.less(right, ((Interval)left).getEnd(), state);
            return startProperContains == null ? null : (endProperContains == null ? null : Boolean.valueOf(startProperContains != false && endProperContains != false));
        }
        if (left instanceof Iterable) {
            List leftList = (List)left;
            if (leftList.size() < 2) {
                return false;
            }
            if (right == null) {
                boolean listContainsNullElements = false;
                boolean listContainsOtherElements = false;
                for (Object element : leftList) {
                    if (element == null) {
                        listContainsNullElements = true;
                        continue;
                    }
                    listContainsOtherElements = true;
                }
                return listContainsNullElements && listContainsOtherElements;
            }
            boolean listContainsGivenElement = false;
            boolean listContainsOtherElements = false;
            boolean listContainsElementsOfUnknownEquality = false;
            for (Object element : leftList) {
                Boolean equalResult = EqualEvaluator.equal(element, right, state);
                if (equalResult == null) {
                    listContainsElementsOfUnknownEquality = true;
                    continue;
                }
                if (equalResult.booleanValue()) {
                    listContainsGivenElement = true;
                    continue;
                }
                listContainsOtherElements = true;
            }
            if (listContainsGivenElement && listContainsOtherElements) {
                return true;
            }
            if (listContainsElementsOfUnknownEquality) {
                return null;
            }
            return false;
        }
        throw new InvalidOperatorArgument("ProperContains(List<T>, T) or ProperContains(Interval<T>, T)", String.format("ProperContains(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean properContains(Object left, Object right, String precision, State state) {
        if (left instanceof Interval && right instanceof BaseTemporal) {
            Boolean startProperContains = AfterEvaluator.after(right, ((Interval)left).getStart(), precision, state);
            Boolean endProperContains = BeforeEvaluator.before(right, ((Interval)left).getEnd(), precision, state);
            return startProperContains == null ? null : (endProperContains == null ? null : Boolean.valueOf(startProperContains != false && endProperContains != false));
        }
        return ProperContainsEvaluator.properContains(left, right, state);
    }
}

