/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.time.format.DateTimeParseException;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;

public class ToDateTimeEvaluator {
    public static Object toDateTime(Object operand, State state) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof DateTime) {
            return operand;
        }
        if (operand instanceof String) {
            try {
                return new DateTime((String)operand, state.getEvaluationDateTime().getZoneOffset());
            }
            catch (DateTimeParseException dtpe) {
                return null;
            }
        }
        if (operand instanceof Date) {
            Date date = (Date)operand;
            return new DateTime(TemporalHelper.zoneToOffset(state.getEvaluationZonedDateTime().getOffset()), date.getDate().getYear(), date.getDate().getMonthValue(), date.getDate().getDayOfMonth()).setPrecision(date.getPrecision());
        }
        throw new InvalidOperatorArgument("ToDateTime(String) or ToDateTime(Date)", String.format("ToDateTime(%s)", operand.getClass().getName()));
    }
}

