/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.exception;

import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.OperandDef;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.execution.Variable;

public class Backtrace {
    private final List<Frame> frames = new LinkedList<Frame>();

    public List<Frame> getFrames() {
        return this.frames;
    }

    public void addFrame(Frame frame) {
        this.frames.add(frame);
    }

    public void maybeAddFrame(ExpressionDef containingDefinition, State.ActivationFrame definitionFrame, Deque<State.ActivationFrame> stack, String contextName, Object contextValue, Expression expression) {
        FunctionoidFrame functionoidFrame;
        Frame currentFrame;
        if (!this.frames.isEmpty() && (currentFrame = this.frames.get(this.frames.size() - 1)) instanceof FunctionoidFrame && (functionoidFrame = (FunctionoidFrame)currentFrame).getDefinition() == containingDefinition) {
            return;
        }
        LinkedList<Variable> arguments = new LinkedList<Variable>();
        LinkedList<Variable> localVariables = new LinkedList<Variable>();
        for (State.ActivationFrame frame : stack) {
            if (frame == definitionFrame) {
                List<Object> parameterNames;
                if (containingDefinition instanceof FunctionDef) {
                    FunctionDef functionDef = (FunctionDef)containingDefinition;
                    parameterNames = functionDef.getOperand().stream().map(OperandDef::getName).collect(Collectors.toList());
                } else {
                    parameterNames = List.of();
                }
                frame.variables.forEach(variable -> {
                    if (parameterNames.contains(variable.getName())) {
                        arguments.add((Variable)variable);
                    } else {
                        localVariables.add((Variable)variable);
                    }
                });
                arguments.sort(Comparator.comparing(argument -> parameterNames.indexOf(argument.getName())));
                break;
            }
            localVariables.addAll(frame.variables);
        }
        this.addFrame(new FunctionoidFrame(expression, containingDefinition, arguments, localVariables, contextName, contextValue));
    }

    public static class Frame {
        private final Expression expression;

        public Frame(Expression expression) {
            this.expression = expression;
        }

        public Expression getExpression() {
            return this.expression;
        }
    }

    public static class FunctionoidFrame
    extends Frame {
        private final ExpressionDef definition;
        private final List<Variable> arguments;
        private final List<Variable> localVariables;
        private final String contextName;
        private final Object contextValue;

        public FunctionoidFrame(Expression expression, ExpressionDef definition, List<Variable> arguments, List<Variable> localVariables, String contextName, Object contextValue) {
            super(expression);
            this.definition = definition;
            this.arguments = arguments;
            this.localVariables = localVariables;
            this.contextName = contextName;
            this.contextValue = contextValue;
        }

        public ExpressionDef getDefinition() {
            return this.definition;
        }

        public List<Variable> getArguments() {
            return this.arguments;
        }

        public List<Variable> getLocalVariables() {
            return this.localVariables;
        }

        public String getContextName() {
            return this.contextName;
        }

        public Object getContextValue() {
            return this.contextValue;
        }
    }
}

