/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.cqframework.cql.cql2elm.CompiledLibraryMultiResults;
import org.cqframework.cql.cql2elm.CompiledLibraryResult;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.debug.SourceLocator;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.execution.Cache;
import org.opencds.cqf.cql.engine.execution.Environment;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.EvaluationResultsForMultiLib;
import org.opencds.cqf.cql.engine.execution.EvaluationVisitor;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.LoadMultiLibResult;
import org.opencds.cqf.cql.engine.execution.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlEngine {
    private static final Logger log = LoggerFactory.getLogger(CqlEngine.class);
    private static final String EXCEPTION_FOR_SUBJECT_ID_MESSAGE_TEMPLATE = "Exception for Library: %s, Message: %s";
    private final Environment environment;
    private final State state;
    private final Set<Options> engineOptions;
    private final EvaluationVisitor evaluationVisitor = new EvaluationVisitor();

    public CqlEngine(Environment environment) {
        this(environment, new HashSet<Options>());
    }

    public CqlEngine(Environment environment, Set<Options> engineOptions) {
        Objects.requireNonNull(environment.getLibraryManager(), "Environment LibraryManager can not be null.");
        this.environment = environment;
        this.engineOptions = engineOptions != null ? engineOptions : EnumSet.of(Options.EnableExpressionCaching);
        this.state = new State(environment, this.engineOptions);
        if (this.engineOptions.contains((Object)Options.EnableExpressionCaching)) {
            this.getCache().setExpressionCaching(true);
        }
        if (this.engineOptions.contains((Object)Options.EnableProfiling)) {
            this.state.ensureDebugResult().ensureProfile();
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public State getState() {
        return this.state;
    }

    public Cache getCache() {
        return this.state.getCache();
    }

    @Deprecated(forRemoval=true)
    public EvaluationVisitor getEvaluationVisitor() {
        return this.evaluationVisitor;
    }

    @Deprecated(forRemoval=true)
    public ExpressionResult expression(VersionedIdentifier libraryIdentifier, String expressionName, ZonedDateTime evaluationDateTime) {
        HashSet<String> set = new HashSet<String>();
        set.add(expressionName);
        EvaluationResult result = this.evaluate(libraryIdentifier, set, null, null, null, evaluationDateTime);
        return result.forExpression(expressionName);
    }

    @Deprecated(forRemoval=true)
    public ExpressionResult expression(VersionedIdentifier libraryIdentifier, String expressionName) {
        return this.expression(libraryIdentifier, expressionName, null);
    }

    public EvaluationResult evaluate(String libraryName) {
        return this.evaluate(libraryName, null, null, null);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions) {
        return this.evaluate(libraryName, expressions, null, null);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryName, expressions, contextParameter, null);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions, Map<String, Object> parameters) {
        return this.evaluate(libraryName, expressions, null, parameters);
    }

    public EvaluationResult evaluate(String libraryName, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryName, null, contextParameter, null);
    }

    public EvaluationResult evaluate(String libraryName, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        return this.evaluate(libraryName, null, contextParameter, parameters);
    }

    public EvaluationResult evaluate(String libraryName, Map<String, Object> parameters) {
        return this.evaluate(libraryName, null, null, parameters);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        return this.evaluate(new VersionedIdentifier().withId(libraryName), expressions, contextParameter, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier) {
        return this.evaluate(libraryIdentifier, null, null, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, ZonedDateTime evaluationDateTime) {
        return this.evaluate(libraryIdentifier, null, null, null, null, evaluationDateTime);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions) {
        return this.evaluate(libraryIdentifier, expressions, null, null, null);
    }

    public EvaluationResultsForMultiLib evaluate(List<VersionedIdentifier> libraryIdentifiers) {
        return this.evaluate(libraryIdentifiers, null, null, null, null);
    }

    public EvaluationResultsForMultiLib evaluate(List<VersionedIdentifier> libraryIdentifiers, Set<String> expressions) {
        return this.evaluate(libraryIdentifiers, expressions, null, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryIdentifier, expressions, contextParameter, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Map<String, Object> parameters) {
        return this.evaluate(libraryIdentifier, expressions, null, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryIdentifier, null, contextParameter, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        return this.evaluate(libraryIdentifier, null, contextParameter, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Map<String, Object> parameters) {
        return this.evaluate(libraryIdentifier, null, null, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters, DebugMap debugMap) {
        return this.evaluate(libraryIdentifier, expressions, contextParameter, parameters, debugMap, null);
    }

    public EvaluationResultsForMultiLib evaluate(List<VersionedIdentifier> libraryIdentifiers, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters, DebugMap debugMap) {
        return this.evaluate(libraryIdentifiers, expressions, contextParameter, parameters, debugMap, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters, DebugMap debugMap, ZonedDateTime evaluationDateTime) {
        return this.evaluate(Collections.singletonList(libraryIdentifier), expressions, contextParameter, parameters, debugMap, evaluationDateTime).getOnlyResultOrThrow();
    }

    public EvaluationResultsForMultiLib evaluate(List<VersionedIdentifier> libraryIdentifiers, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters, DebugMap debugMap, ZonedDateTime nullableEvaluationDateTime) {
        if (libraryIdentifiers == null || libraryIdentifiers.isEmpty() || libraryIdentifiers.get(0) == null) {
            throw new IllegalArgumentException("libraryIdentifier can not be null or empty.");
        }
        LoadMultiLibResult loadMultiLibResult = this.loadAndValidate(libraryIdentifiers);
        this.initializeEvalTime(nullableEvaluationDateTime);
        this.state.init(loadMultiLibResult.getAllLibraries());
        if (contextParameter != null) {
            this.state.setContextValue((String)contextParameter.getLeft(), contextParameter.getRight());
        }
        loadMultiLibResult.getAllLibraries().forEach(library -> this.state.setParameters((Library)library, parameters));
        this.initializeDebugMap(debugMap);
        List<VersionedIdentifier> reversedOrderLibraryIdentifiers = IntStream.range(0, loadMultiLibResult.libraryCount()).map(index -> loadMultiLibResult.getAllLibraryIds().size() - 1 - index).mapToObj(loadMultiLibResult::getLibraryIdentifierAtIndex).toList();
        EvaluationResultsForMultiLib.Builder resultBuilder = EvaluationResultsForMultiLib.builder(loadMultiLibResult);
        for (VersionedIdentifier libraryIdentifier : reversedOrderLibraryIdentifiers) {
            Library library2 = loadMultiLibResult.retrieveLibrary(libraryIdentifier);
            Set<String> expressionSet = expressions == null ? this.getExpressionSet(library2) : expressions;
            String joinedExpressions = String.join((CharSequence)", ", expressionSet);
            log.debug("Evaluating library: {} with expressions: [{}]", (Object)libraryIdentifier.getId(), (Object)joinedExpressions);
            try {
                EvaluationResult evaluationResult = this.evaluateExpressions(expressionSet);
                resultBuilder.addResult(libraryIdentifier, evaluationResult);
            }
            catch (RuntimeException exception) {
                String error = EXCEPTION_FOR_SUBJECT_ID_MESSAGE_TEMPLATE.formatted(libraryIdentifier.getId(), exception.getMessage());
                log.error(error);
                resultBuilder.addException(libraryIdentifier, exception);
            }
        }
        return resultBuilder.build();
    }

    private void initializeEvalTime(ZonedDateTime nullableEvaluationDateTime) {
        this.state.setEvaluationDateTime(Objects.requireNonNullElseGet(nullableEvaluationDateTime, ZonedDateTime::now));
    }

    private void initializeDebugMap(DebugMap debugMap) {
        if (debugMap != null) {
            this.state.setDebugMap(debugMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvaluationResult evaluateExpressions(Set<String> expressions) {
        EvaluationResult result = new EvaluationResult();
        this.state.beginEvaluation();
        try {
            for (String expression : expressions) {
                Library currentLibrary;
                ExpressionDef def = Libraries.resolveExpressionRef(expression, currentLibrary = this.state.getCurrentLibrary());
                if (def == null) {
                    throw new CqlException(String.format("Unable to resolve expression \"%s.\"", expression));
                }
                if (def instanceof FunctionDef) continue;
                try {
                    DebugAction action = this.getState().shouldDebug((Element)def);
                    this.state.pushActivationFrame((Element)def, def.getContext());
                    try {
                        Object object = this.evaluationVisitor.visitExpressionDef(def, this.state);
                        result.expressionResults.put(expression, new ExpressionResult(object, this.state.getEvaluatedResources()));
                        this.state.logDebugResult((Element)def, object, action);
                    }
                    finally {
                        this.state.popActivationFrame();
                        this.state.clearEvaluatedResources();
                    }
                }
                catch (CqlException ce) {
                    this.processException(ce, (Element)def);
                }
                catch (Exception e) {
                    this.processException(e, (Element)def, String.format("Error evaluating expression %s: %s", expression, e.getMessage()));
                }
            }
        }
        finally {
            this.state.endEvaluation();
            this.state.clearEvaluatedResources();
            this.state.exitLibrary(true);
        }
        result.setDebugResult(this.state.getDebugResult());
        return result;
    }

    private void loadAndValidate(VersionedIdentifier libraryIdentifier) {
        ArrayList errors = new ArrayList();
        Library library = this.environment.getLibraryManager().resolveLibrary(libraryIdentifier, errors).getLibrary();
        if (library == null) {
            throw new CqlException(String.format("Unable to load library %s", libraryIdentifier.getId() + (String)(libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : "")));
        }
        if (CqlCompilerException.hasErrors(errors)) {
            throw new CqlException(String.format("library %s loaded, but had errors: %s", libraryIdentifier.getId() + (String)(libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : ""), errors.stream().map(Throwable::getMessage).collect(Collectors.joining(", "))));
        }
        if (this.engineOptions.contains((Object)Options.EnableValidation)) {
            this.validateTerminologyRequirements(library);
            this.validateDataRequirements(library);
        }
        if (library.getIncludes() != null && library.getIncludes().getDef() != null) {
            for (IncludeDef include : library.getIncludes().getDef()) {
                this.loadAndValidate(new VersionedIdentifier().withSystem(NamespaceManager.getUriPart((String)include.getPath())).withId(NamespaceManager.getNamePart((String)include.getPath())).withVersion(include.getVersion()));
            }
        }
    }

    private LoadMultiLibResult loadAndValidate(List<VersionedIdentifier> libraryIdentifiers) {
        CompiledLibraryMultiResults resolvedLibraryResults = this.environment.getLibraryManager().resolveLibraries(libraryIdentifiers);
        LoadMultiLibResult.Builder resultBuilder = LoadMultiLibResult.builder();
        if (CqlCompilerException.hasErrors((List)resolvedLibraryResults.allErrors())) {
            for (CompiledLibraryResult libraryResult : resolvedLibraryResults.allResults()) {
                if (libraryResult.errors().isEmpty()) continue;
                VersionedIdentifier identifier = libraryResult.compiledLibrary().getIdentifier();
                resultBuilder.addException(identifier, this.wrapException(identifier, libraryResult.errors()));
            }
        }
        List libraries = resolvedLibraryResults.allLibrariesWithoutErrorSeverity();
        this.validateLibrariesIfNeeded(libraries);
        for (Library library : libraries) {
            try {
                if (library.getIncludes() != null && library.getIncludes().getDef() != null) {
                    for (IncludeDef include : library.getIncludes().getDef()) {
                        this.loadAndValidate(new VersionedIdentifier().withSystem(NamespaceManager.getUriPart((String)include.getPath())).withId(NamespaceManager.getNamePart((String)include.getPath())).withVersion(include.getVersion()));
                    }
                }
                resultBuilder.addResult(library.getIdentifier(), library);
            }
            catch (CqlCompilerException | CqlException exception) {
                resultBuilder.addException(library.getIdentifier(), (RuntimeException)exception);
            }
        }
        return resultBuilder.build();
    }

    private void validateLibrariesIfNeeded(List<Library> libraries) {
        if (this.engineOptions.contains((Object)Options.EnableValidation)) {
            libraries.forEach(library -> {
                this.validateTerminologyRequirements((Library)library);
                this.validateDataRequirements((Library)library);
            });
        }
    }

    private CqlException wrapException(VersionedIdentifier libraryIdentifier, List<CqlCompilerException> exceptions) {
        return new CqlException("Library %s loaded, but had errors: %s".formatted(libraryIdentifier.getId() + (String)(libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : ""), exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", "))));
    }

    private void validateDataRequirements(Library library) {
        if (library.getUsings() != null && library.getUsings().getDef() != null && !library.getUsings().getDef().isEmpty()) {
            for (UsingDef using : library.getUsings().getDef()) {
                if (using.getUri().equals("urn:hl7-org:elm-types:r1") || this.environment.getDataProviders() != null && this.environment.getDataProviders().containsKey(using.getUri())) continue;
                throw new IllegalArgumentException(String.format("Library %1$s is using %2$s and no data provider is registered for uri %2$s.", this.getLibraryDescription(library.getIdentifier()), using.getUri()));
            }
        }
    }

    private void validateTerminologyRequirements(Library library) {
        if (library.getCodeSystems() != null && library.getCodeSystems().getDef() != null && !library.getCodeSystems().getDef().isEmpty() || library.getCodes() != null && library.getCodes().getDef() != null && !library.getCodes().getDef().isEmpty() || library.getValueSets() != null && library.getValueSets().getDef() != null && !library.getValueSets().getDef().isEmpty() && this.environment.getTerminologyProvider() == null) {
            throw new IllegalArgumentException(String.format("Library %s has terminology requirements and no terminology provider is registered.", this.getLibraryDescription(library.getIdentifier())));
        }
    }

    private String getLibraryDescription(VersionedIdentifier libraryIdentifier) {
        return libraryIdentifier.getId() + (String)(libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : "");
    }

    private Set<String> getExpressionSet(Library library) {
        LinkedHashSet<String> expressionNames = new LinkedHashSet<String>();
        if (library.getStatements() != null && library.getStatements().getDef() != null) {
            for (ExpressionDef ed : library.getStatements().getDef()) {
                expressionNames.add(ed.getName());
            }
        }
        return expressionNames;
    }

    public void processException(CqlException e, Element element) {
        if (e.getSourceLocator() == null) {
            e.setSourceLocator(SourceLocator.fromNode(element, this.getState().getCurrentLibrary()));
            DebugAction action = this.state.shouldDebug(e);
            if (action != DebugAction.NONE) {
                this.state.logDebugError(e);
            }
        }
        throw e;
    }

    public void processException(Exception e, Element element, String message) {
        CqlException ce = new CqlException(message, e, SourceLocator.fromNode(element, this.getState().getCurrentLibrary()));
        DebugAction action = this.state.shouldDebug(ce);
        if (action != DebugAction.NONE) {
            this.state.logDebugError(ce);
        }
        throw ce;
    }

    public static enum Options {
        EnableExpressionCaching,
        EnableValidation,
        EnableHedisCompatibilityMode,
        EnableProfiling;

    }
}

