/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.LoadMultiLibResult;

public class EvaluationResultsForMultiLib {
    private final Map<VersionedIdentifier, EvaluationResult> results;
    private final Map<VersionedIdentifier, RuntimeException> exceptions;

    private EvaluationResultsForMultiLib(Builder builder) {
        this.results = Collections.unmodifiableMap(builder.results);
        this.exceptions = Collections.unmodifiableMap(builder.exceptions);
    }

    Map<VersionedIdentifier, EvaluationResult> getResults() {
        return this.results;
    }

    Map<VersionedIdentifier, RuntimeException> getExceptions() {
        return this.exceptions;
    }

    public boolean containsResultsFor(VersionedIdentifier libraryIdentifier) {
        return this.getResultFor(libraryIdentifier) != null;
    }

    public boolean containsExceptionsFor(VersionedIdentifier libraryIdentifier) {
        return this.exceptions.containsKey(libraryIdentifier);
    }

    public EvaluationResult getResultFor(VersionedIdentifier libraryIdentifier) {
        if (this.results.containsKey(libraryIdentifier)) {
            return this.results.get(libraryIdentifier);
        }
        if (libraryIdentifier.getVersion() == null || libraryIdentifier.getVersion().isEmpty()) {
            return this.results.entrySet().stream().filter(entry -> this.matchIdentifiers(libraryIdentifier, (Map.Entry<VersionedIdentifier, EvaluationResult>)entry)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return null;
    }

    public EvaluationResult getOnlyResultOrThrow() {
        if (this.results.size() > 1 || this.exceptions.size() > 1) {
            throw new IllegalStateException("Did you run an evaluation for multiple libraries?  Expected exactly one result or error, but found results: %s errors: %s: ".formatted(this.results.size(), this.exceptions.size()));
        }
        RuntimeException firstException = this.getFirstException();
        if (firstException != null) {
            throw firstException;
        }
        return this.getFirstResult();
    }

    public RuntimeException getExceptionFor(VersionedIdentifier libraryIdentifier) {
        return this.exceptions.getOrDefault(libraryIdentifier, null);
    }

    private boolean matchIdentifiers(VersionedIdentifier libraryIdentifier, Map.Entry<VersionedIdentifier, EvaluationResult> entry) {
        return entry.getKey().getId().equals(libraryIdentifier.getId());
    }

    private EvaluationResult getFirstResult() {
        Collection<EvaluationResult> allEvaluationResults = this.results.values();
        if (allEvaluationResults.size() > 1) {
            throw new IllegalStateException("Did you run an evaluation for multiple libraries?  Expected 0-1 results, but found: %s".formatted(this.results.size()));
        }
        return allEvaluationResults.stream().findFirst().orElse(null);
    }

    private RuntimeException getFirstException() {
        if (this.exceptions.isEmpty()) {
            return null;
        }
        return this.exceptions.values().iterator().next();
    }

    public boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    static Builder builder(LoadMultiLibResult loadMultiLibResult) {
        return new Builder(loadMultiLibResult);
    }

    static class Builder {
        private final LinkedHashMap<VersionedIdentifier, EvaluationResult> results = new LinkedHashMap();
        private final LinkedHashMap<VersionedIdentifier, RuntimeException> exceptions = new LinkedHashMap();

        Builder(LoadMultiLibResult loadMultiLibResult) {
            this.exceptions.putAll(loadMultiLibResult.getExceptions());
        }

        void addResult(VersionedIdentifier libraryId, EvaluationResult evaluationResult) {
            this.results.put(libraryId, evaluationResult);
        }

        void addException(VersionedIdentifier libraryId, RuntimeException exception) {
            this.exceptions.put(this.withIdOnly(libraryId), exception);
        }

        EvaluationResultsForMultiLib build() {
            return new EvaluationResultsForMultiLib(this);
        }

        private VersionedIdentifier withIdOnly(VersionedIdentifier libraryId) {
            return new VersionedIdentifier().withId(libraryId.getId());
        }
    }
}

