/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.VersionedIdentifier;

class LoadMultiLibResult {
    private final Map<VersionedIdentifier, Library> results;
    private final Map<VersionedIdentifier, RuntimeException> exceptions;

    private LoadMultiLibResult(Builder builder) {
        this.results = Collections.unmodifiableMap(builder.results);
        this.exceptions = Collections.unmodifiableMap(builder.exceptions);
    }

    int libraryCount() {
        return this.results.size();
    }

    List<VersionedIdentifier> getAllLibraryIds() {
        return List.copyOf(this.results.keySet());
    }

    List<Library> getAllLibraries() {
        return List.copyOf(this.results.values());
    }

    VersionedIdentifier getLibraryIdentifierAtIndex(int index) {
        if (index < 0 || index >= this.getAllLibraries().size()) {
            throw new IllegalStateException("Index out of bounds: " + index);
        }
        return this.getAllLibraryIds().get(index);
    }

    Library retrieveLibrary(VersionedIdentifier libraryIdentifier) {
        if (libraryIdentifier.getVersion() != null) {
            if (!this.results.containsKey(libraryIdentifier)) {
                throw new IllegalArgumentException(String.format("libraryIdentifier '%s' does not exist.", libraryIdentifier));
            }
            return this.results.get(libraryIdentifier);
        }
        return this.results.entrySet().stream().filter(entry -> ((VersionedIdentifier)entry.getKey()).getId().equals(libraryIdentifier.getId())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("library id %s not found.", libraryIdentifier.getId())));
    }

    Map<VersionedIdentifier, RuntimeException> getExceptions() {
        return this.exceptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final LinkedHashMap<VersionedIdentifier, Library> results = new LinkedHashMap();
        private final LinkedHashMap<VersionedIdentifier, RuntimeException> exceptions = new LinkedHashMap();

        void addResult(VersionedIdentifier libraryId, Library library) {
            this.results.put(libraryId, library);
        }

        void addException(VersionedIdentifier libraryId, RuntimeException exception) {
            this.exceptions.put(libraryId, exception);
        }

        LoadMultiLibResult build() {
            return new LoadMultiLibResult(this);
        }
    }
}

