/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.Retrieve;
import org.opencds.cqf.cql.engine.execution.State;

public class Profile {
    private final Node tree = new Node(null, null);
    private final Deque<Node> stack = new ArrayDeque<Node>();

    public Node getTree() {
        return this.tree;
    }

    public void enter(State.ActivationFrame frame) {
        Node newNode;
        Node topNode = this.stack.peek();
        if (topNode == null) {
            assert (frame.element == null);
            assert (frame.contextName == null);
            newNode = this.tree;
        } else {
            newNode = topNode.ensureChild(frame.element, frame.contextName);
        }
        this.stack.push(newNode);
    }

    public void leave(State.ActivationFrame frame) {
        Node topNode = this.stack.peek();
        assert (topNode != null);
        assert (topNode.expression == frame.element);
        assert (Objects.equals(topNode.context, frame.contextName));
        topNode.addInvocation(frame.startTime, frame.endTime, frame.isCached);
        this.stack.pop();
    }

    public void register(Collection<State.ActivationFrame> stack) {
        this.tree.register(stack);
    }

    public Profile merge(Profile other) {
        this.tree.merge(other.tree);
        return this;
    }

    public static Profile merge(Collection<Profile> profiles) {
        Profile result = new Profile();
        profiles.forEach(result::merge);
        return result;
    }

    public void render(Writer writer) throws IOException {
        writer.append("<svg>\n");
        this.tree.render(writer);
        writer.append("</svg>\n");
    }

    public void render(OutputStream outputStream) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            this.render(writer);
        }
    }

    public void render(Path outputFile) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(outputFile.toFile());){
            this.render(stream);
        }
    }

    public static class Node {
        public Map<String, IdentityHashMap<Element, Node>> children = new HashMap<String, IdentityHashMap<Element, Node>>();
        public Element expression;
        public String context;
        public long count = 0L;
        public long time = 0L;
        public long misses = 0L;

        public Node(Element expression, String context) {
            this.expression = expression;
            this.context = context;
        }

        public void addInvocation(long startTime, long endTime, boolean isHit) {
            long elapsed = endTime - startTime;
            assert (elapsed >= 0L);
            ++this.count;
            this.time += elapsed;
            this.misses += isHit ? 0L : 1L;
        }

        public Node ensureChild(Element expression, String context) {
            return this.children.computeIfAbsent(context, context2 -> new IdentityHashMap()).computeIfAbsent(expression, expression2 -> new Node(expression, context));
        }

        public Node register(Collection<State.ActivationFrame> stack) {
            ArrayList<State.ActivationFrame> frames = new ArrayList<State.ActivationFrame>(stack);
            return this.registerStep(frames, frames.size() - 1);
        }

        private Node registerStep(List<State.ActivationFrame> stack, int index) {
            if (index == -1) {
                State.ActivationFrame frame = stack.get(0);
                this.addInvocation(frame.startTime, frame.endTime, frame.isCached);
                return this;
            }
            State.ActivationFrame frame = stack.get(index);
            Element expression = frame.element;
            String contextName = frame.contextName;
            Node child = expression != null ? this.ensureChild(expression, contextName) : this;
            return child.registerStep(stack, index - 1);
        }

        public Node merge(Node other) {
            this.count += other.count;
            this.time += other.time;
            this.misses += other.misses;
            other.children.forEach((context, mapForContext) -> mapForContext.forEach((element, otherChild) -> {
                Node child = this.ensureChild((Element)element, (String)context);
                child.merge((Node)otherChild);
            }));
            return this;
        }

        public void render(Writer writer) throws IOException {
            double duration = (double)this.time / 1.0E9;
            int maxDepth = 10;
            double scaleX = 4000.0 / duration;
            double scaleY = 80.0;
            this.renderStep(writer, 0, 0.0, 0, scaleX, 80.0);
        }

        public double renderStep(Writer writer, int i, double x, int depth, double scaleX, double scaleY) throws IOException {
            double timeInSeconds = (double)this.time / 1.0E9;
            double x1 = scaleX * x;
            double x2 = scaleX * (x + timeInSeconds);
            double y1 = scaleY * (double)depth;
            double y2 = scaleY * (double)(depth + 1);
            int red = 50 * depth % 256;
            int green = 50 * i % 256;
            int blue = this.expression instanceof FunctionDef ? 128 : 0;
            String color = String.format("#%02x%02x%02x", red, green, blue);
            String idString = String.format("%d-%f", depth, x);
            String rectString = String.format("  <rect x=\"%f\" y=\"%f\" width=\"%f\" height=\"%f\" style=\"fill:%s;stroke:%s;fill-opacity:0.5;\"/>\n", x1, y1, x2 - x1, y2 - y1, color, color);
            writer.append(rectString);
            writer.append(String.format("    <defs>\n      <clipPath id=\"%s\">%s</clipPath>\n    </defs>\n", idString, rectString));
            writer.append(String.format("    <text x=\"%f\" y=\"%f\" clip-path=\"url(#%s)\"><tspan>%s</tspan></text>\n", x1, y1 + (y2 - y1) * 0.15, idString, this.expressionLabel(this.expression)));
            writer.append(String.format("    <text x=\"%f\" y=\"%f\" clip-path=\"url(#%s)\"><tspan>%,3d ms</tspan></text>\n", x1, y1 + (y2 - y1) * 0.35, idString, this.time / 1000000L));
            writer.append(String.format("    <text x=\"%f\" y=\"%f\" clip-path=\"url(#%s)\"><tspan>%,3d Calls</tspan></text>\n", x1, y1 + (y2 - y1) * 0.55, idString, this.count));
            writer.append(String.format("    <text x=\"%f\" y=\"%f\" clip-path=\"url(#%s)\"><tspan>%,3d Misses</tspan></text>\n", x1, y1 + (y2 - y1) * 0.75, idString, this.misses));
            List sorted = this.children.values().stream().flatMap(contextMap -> contextMap.values().stream()).sorted(Comparator.comparing(node -> -node.time)).collect(Collectors.toList());
            double xc = x;
            for (Node child : sorted) {
                xc = child.renderStep(writer, i++, xc, depth + 1, scaleX, scaleY);
            }
            return x + timeInSeconds;
        }

        private String expressionLabel(Element expression) {
            StringBuilder result = new StringBuilder();
            if (expression == null) {
                result.append("\u00abroot\u00bb");
            } else if (expression instanceof Retrieve) {
                Retrieve retrieve = (Retrieve)expression;
                result.append(String.format("[%s]", retrieve.getDataType().getLocalPart()));
            } else if (expression instanceof ExpressionDef) {
                ExpressionDef expressionDef = (ExpressionDef)expression;
                result.append(expressionDef.getName());
                if (expression instanceof FunctionDef) {
                    result.append("()");
                }
            } else {
                result.append("unknown expression type");
            }
            if (this.context != null) {
                result.append(" (");
                result.append(this.context);
                result.append(")");
            }
            return result.toString();
        }

        public String toString() {
            return String.format("Node{expression=%s, context=%s, count=%d, time=%s ms, misses=%d}", this.expressionLabel(this.expression), this.context, this.count, this.time, this.misses);
        }
    }
}

