/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.debug.DebugResult;
import org.opencds.cqf.cql.engine.debug.SourceLocator;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.exception.Severity;
import org.opencds.cqf.cql.engine.execution.Cache;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.Environment;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.Profile;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Tuple;

public class State {
    private final Cache cache = new Cache();
    private final Set<CqlEngine.Options> engineOptions;
    private final Environment environment;
    private final Deque<String> currentContext = new ArrayDeque<String>();
    private final Deque<Library> currentLibrary = new ArrayDeque<Library>();
    private final Deque<ActivationFrame> stack = new ArrayDeque<ActivationFrame>();
    private final Deque<HashSet<Object>> evaluatedResourceStack = new ArrayDeque<HashSet<Object>>();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, Object> contextValues = new HashMap<String, Object>();
    private ZonedDateTime evaluationZonedDateTime;
    private DateTime evaluationDateTime;
    private DebugMap debugMap;
    private DebugResult debugResult;

    public State(Environment environment) {
        this(environment, new HashSet<CqlEngine.Options>());
    }

    public State(Environment environment, Set<CqlEngine.Options> engineOptions) {
        this.environment = Objects.requireNonNull(environment);
        this.engineOptions = Objects.requireNonNull(engineOptions);
        this.setEvaluationDateTime(ZonedDateTime.now());
    }

    public Cache getCache() {
        return this.cache;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Library getCurrentLibrary() {
        return this.currentLibrary.peek();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Set<CqlEngine.Options> getEngineOptions() {
        return this.engineOptions;
    }

    public void setParameters(Library library, Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> parameterValue : parameters.entrySet()) {
                this.setParameter(null, parameterValue.getKey(), parameterValue.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String libraryName, String name, Object value) {
        boolean enteredLibrary = this.enterLibrary(libraryName);
        try {
            String fullName = libraryName != null ? String.format("%s.%s", this.getCurrentLibrary().getIdentifier().getId(), name) : name;
            this.parameters.put(fullName, value);
        }
        finally {
            this.exitLibrary(enteredLibrary);
        }
    }

    public boolean enterLibrary(String libraryName) {
        if (libraryName != null) {
            IncludeDef includeDef = Libraries.resolveLibraryRef(libraryName, this.getCurrentLibrary());
            VersionedIdentifier identifier = Libraries.toVersionedIdentifier(includeDef);
            Library library = this.getEnvironment().resolveLibrary(identifier);
            this.currentLibrary.push(library);
            return true;
        }
        return false;
    }

    public void exitLibrary(boolean enteredLibrary) {
        if (enteredLibrary) {
            this.currentLibrary.pop();
        }
    }

    public Map<String, Object> getContextValues() {
        return this.contextValues;
    }

    public void setContextValues(Map<String, Object> contextValues) {
        this.contextValues = contextValues;
    }

    @Deprecated
    public Deque<Deque<Variable>> getWindows() {
        ArrayDeque<Deque<Variable>> result = new ArrayDeque<Deque<Variable>>();
        this.stack.forEach(frame -> result.push(frame.variables));
        return result;
    }

    @Deprecated
    public void setWindows(Deque<Deque<Variable>> windows) {
        throw new RuntimeException("Not supported");
    }

    public DebugMap getDebugMap() {
        return this.debugMap;
    }

    public void setDebugMap(DebugMap debugMap) {
        this.debugMap = debugMap;
    }

    public DebugResult getDebugResult() {
        return this.debugResult;
    }

    public DebugResult ensureDebugResult() {
        if (this.debugResult == null) {
            this.debugResult = new DebugResult();
        }
        return this.debugResult;
    }

    public DebugAction shouldDebug(Exception e) {
        if (this.debugMap == null) {
            return DebugAction.NONE;
        }
        return this.debugMap.shouldDebug(e);
    }

    public DebugAction shouldDebug(Element node) {
        if (this.debugMap == null) {
            return DebugAction.NONE;
        }
        return this.debugMap.shouldDebug(node, this.getCurrentLibrary());
    }

    public void setEvaluationDateTime(ZonedDateTime evaluationZonedDateTime) {
        this.evaluationZonedDateTime = evaluationZonedDateTime;
        this.evaluationDateTime = new DateTime(evaluationZonedDateTime.toOffsetDateTime());
    }

    public ZonedDateTime getEvaluationZonedDateTime() {
        return this.evaluationZonedDateTime;
    }

    public DateTime getEvaluationDateTime() {
        return this.evaluationDateTime;
    }

    public void init(Library library) {
        assert (this.stack.isEmpty());
        this.currentLibrary.push(library);
        this.pushEvaluatedResourceStack();
    }

    public void init(List<Library> libraries) {
        assert (this.stack.isEmpty());
        for (Library library : libraries) {
            this.currentLibrary.push(library);
            this.pushEvaluatedResourceStack();
        }
    }

    public Deque<ActivationFrame> getStack() {
        return this.stack;
    }

    public void pop() {
        ActivationFrame topActivationFrame = this.stack.peek();
        if (topActivationFrame == null) {
            throw new IllegalStateException("Stack underflow");
        }
        topActivationFrame.variables.pop();
    }

    public void push(Variable variable) {
        ActivationFrame topActivationFrame = this.stack.peek();
        if (topActivationFrame == null) {
            throw new IllegalStateException("Stack underflow: No activation frame available.");
        }
        topActivationFrame.variables.push(variable);
    }

    public void beginEvaluation() {
        assert (this.stack.isEmpty());
        this.pushActivationFrame(null);
    }

    public void endEvaluation() {
        assert (this.stack.size() == 1);
        this.popActivationFrame();
    }

    public Variable resolveVariable(String name) {
        for (ActivationFrame frame : this.stack) {
            for (Variable v : frame.variables) {
                if (!v.getName().equals(name)) continue;
                return v;
            }
        }
        return null;
    }

    public Variable resolveVariable(String name, boolean mustResolve) {
        Variable result = this.resolveVariable(name);
        if (mustResolve && result == null) {
            throw new CqlException(String.format("Could not resolve variable reference %s", name));
        }
        return result;
    }

    public void pushActivationFrame(Element element, String contextName, long startTime) {
        Profile profile;
        ActivationFrame newActivationFrame = new ActivationFrame(element, contextName, startTime);
        this.stack.push(newActivationFrame);
        if (this.debugResult != null && (profile = this.debugResult.getProfile()) != null) {
            profile.enter(newActivationFrame);
        }
    }

    public void pushActivationFrame(Element element, String contextName) {
        this.pushActivationFrame(element, contextName, System.nanoTime());
    }

    public void pushActivationFrame(Element element) {
        String contextName = this.currentContext.peekFirst();
        this.pushActivationFrame(element, contextName);
    }

    public void popActivationFrame() {
        Profile profile;
        ActivationFrame topActivationFrame = this.stack.peek();
        if (topActivationFrame == null) {
            throw new RuntimeException("Stack underflow");
        }
        assert (topActivationFrame.endTime == 0L);
        if (this.debugResult != null && (profile = this.debugResult.getProfile()) != null) {
            topActivationFrame.endTime = System.nanoTime();
            profile.leave(topActivationFrame);
        }
        this.stack.pop();
    }

    public ActivationFrame getTopActivationFrame() {
        ActivationFrame topActivationFrame = this.stack.peek();
        if (topActivationFrame == null) {
            throw new RuntimeException("Stack underflow");
        }
        return topActivationFrame;
    }

    public void setContextValue(String context, Object contextValue) {
        boolean containsKey = this.contextValues.containsKey(context);
        Object valueFromContextValues = this.contextValues.get(context);
        boolean valuesAreEqual = contextValue.equals(valueFromContextValues);
        if (!containsKey || !valuesAreEqual) {
            this.contextValues.put(context, contextValue);
            this.clearCacheExpressions();
        }
    }

    private void clearCacheExpressions() {
        this.cache.getExpressions().clear();
    }

    public boolean enterContext(String context) {
        if (context != null) {
            this.currentContext.push(context);
            return true;
        }
        return false;
    }

    public void exitContext(boolean isEnteredContext) {
        if (isEnteredContext) {
            this.currentContext.pop();
        }
    }

    public String getCurrentContext() {
        if (this.currentContext.isEmpty()) {
            return null;
        }
        return this.currentContext.peekFirst();
    }

    public Object getCurrentContextValue() {
        String context = this.getCurrentContext();
        if (context != null && this.contextValues.containsKey(context)) {
            return this.contextValues.get(context);
        }
        return null;
    }

    public Set<Object> getEvaluatedResources() {
        if (this.evaluatedResourceStack.isEmpty()) {
            throw new IllegalStateException("Attempted to get the evaluatedResource stack when it's empty");
        }
        return this.evaluatedResourceStack.peek();
    }

    public void clearEvaluatedResources() {
        this.evaluatedResourceStack.clear();
        this.pushEvaluatedResourceStack();
    }

    public void pushEvaluatedResourceStack() {
        this.evaluatedResourceStack.push(new HashSet());
    }

    public void popEvaluatedResourceStack() {
        if (this.evaluatedResourceStack.isEmpty()) {
            throw new IllegalStateException("Attempted to pop the evaluatedResource stack when it's empty");
        }
        if (this.evaluatedResourceStack.size() == 1) {
            throw new IllegalStateException("Attempted to pop the evaluatedResource stack when only the root remains");
        }
        Set objects = this.evaluatedResourceStack.pop();
        HashSet<Object> set = this.evaluatedResourceStack.peek();
        set.addAll(objects);
    }

    public Object resolveAlias(String name) {
        for (Variable v : this.getTopActivationFrame().variables) {
            if (!v.getName().equals(name)) continue;
            return v.getValue();
        }
        throw new IllegalStateException("Could not resolve alias reference %s in the current context".formatted(name));
    }

    public Object resolveIdentifierRef(String name) {
        for (ActivationFrame frame : this.stack) {
            for (Variable v : frame.variables) {
                if (v.getName().equals(name)) {
                    return v.getValue();
                }
                Object value = v.getValue();
                if (value instanceof Tuple) {
                    for (String key : ((Tuple)value).getElements().keySet()) {
                        if (!key.equals(name)) continue;
                        return ((Tuple)value).getElements().get(key);
                    }
                }
                try {
                    return this.environment.resolvePath(value, name);
                }
                catch (Exception exception) {
                }
            }
        }
        throw new CqlException("Cannot resolve identifier " + name);
    }

    public void logDebugResult(Element node, Object result, DebugAction action) {
        this.ensureDebugResult();
        this.debugResult.logDebugResult(node, this.getCurrentLibrary(), result, action);
    }

    public void logDebugMessage(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.MESSAGE));
    }

    public void logDebugWarning(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.WARNING));
    }

    public void logDebugTrace(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.TRACE));
    }

    public void logDebugError(CqlException e) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(e);
    }

    public static class ActivationFrame {
        public Deque<Variable> variables = new ArrayDeque<Variable>(4);
        public Element element;
        public String contextName;
        public long startTime;
        public long endTime = 0L;
        public boolean isCached = false;

        public ActivationFrame(Element element, String contextName, long startTime) {
            this.element = element;
            this.contextName = contextName;
            this.startTime = startTime;
        }

        public String toString() {
            StringBuilder result = new StringBuilder().append("Frame{element=");
            if (this.element == null) {
                result.append("\u00abroot\u00bb");
            } else {
                Element element = this.element;
                if (element instanceof ExpressionDef) {
                    ExpressionDef expressionDef = (ExpressionDef)element;
                    result.append(expressionDef.getName());
                } else {
                    element = this.element;
                    if (element instanceof Retrieve) {
                        Retrieve retrieve = (Retrieve)element;
                        result.append(String.format("[%s]", retrieve.getDataType().getLocalPart()));
                    } else {
                        result.append(this.element.getClass().getSimpleName());
                    }
                }
            }
            if (this.endTime == 0L) {
                result.append(", active");
            } else {
                result.append(String.format(", %,d ms", (this.endTime - this.startTime) / 1000000L));
            }
            if (this.isCached) {
                result.append(", cached");
            }
            return result.append("}").toString();
        }
    }
}

