/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidPrecision;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Value;

public class IntervalHelper {
    private IntervalHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Object findNonNullBoundary(List<Interval> intervals) {
        return intervals.stream().filter(Objects::nonNull).flatMap(interval -> Stream.of(interval.getStart(), interval.getEnd())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Quantity quantityFromCoarsestPrecisionOfBoundaries(List<Interval> intervals) {
        Object nonNullBoundary = IntervalHelper.findNonNullBoundary(intervals);
        if (nonNullBoundary instanceof BigDecimal) {
            int scale = Value.getCoarsestScale(intervals.stream().filter(Objects::nonNull).flatMap(interval -> Stream.of((BigDecimal)interval.getStart(), (BigDecimal)interval.getEnd())));
            return new Quantity().withValue(BigDecimal.ONE.setScale(scale, RoundingMode.UNNECESSARY)).withDefaultUnit();
        }
        if (nonNullBoundary instanceof Quantity) {
            Quantity quantity = (Quantity)nonNullBoundary;
            int scale = Value.getCoarsestScale(intervals.stream().filter(Objects::nonNull).flatMap(interval -> Stream.of((Quantity)interval.getStart(), (Quantity)interval.getEnd())).filter(Objects::nonNull).map(Quantity::getValue));
            return new Quantity().withValue(BigDecimal.ONE.setScale(scale, RoundingMode.UNNECESSARY)).withUnit(quantity.getUnit());
        }
        if (nonNullBoundary instanceof BaseTemporal) {
            String precision = BaseTemporal.getLowestPrecision((BaseTemporal[])intervals.stream().filter(Objects::nonNull).flatMap(interval -> Stream.of((BaseTemporal)interval.getStart(), (BaseTemporal)interval.getEnd())).toArray(BaseTemporal[]::new));
            return new Quantity().withValue(BigDecimal.ONE).withUnit(precision);
        }
        return new Quantity().withValue(BigDecimal.ONE).withDefaultUnit();
    }

    public static boolean isQuantityCompatibleWithBoundaries(Quantity quantity, List<Interval> intervals) {
        Object nonNullBoundary = IntervalHelper.findNonNullBoundary(intervals);
        if (nonNullBoundary instanceof Integer || nonNullBoundary instanceof Long || nonNullBoundary instanceof BigDecimal) {
            return Quantity.isDefaultUnit(quantity.getUnit());
        }
        if (nonNullBoundary instanceof Quantity) {
            Quantity nonNullBoundaryQuantity = (Quantity)nonNullBoundary;
            return Quantity.unitsEqual(quantity.getUnit(), nonNullBoundaryQuantity.getUnit());
        }
        if (nonNullBoundary instanceof BaseTemporal) {
            try {
                Precision.fromString(quantity.getUnit());
                return true;
            }
            catch (InvalidPrecision e) {
                return false;
            }
        }
        return true;
    }

    public static Interval truncateIntervalBoundaries(Interval interval, Quantity quantity, State state) {
        Object start = interval.getStart();
        Object end = interval.getEnd();
        if (start instanceof BigDecimal) {
            BigDecimal startBigDecimal = (BigDecimal)start;
            if (end instanceof BigDecimal) {
                BigDecimal truncatedEnd;
                BigDecimal endBigDecimal = (BigDecimal)end;
                int quantityScale = quantity.getValue().scale();
                BigDecimal truncatedStart = Value.roundToScale(startBigDecimal, quantityScale, true);
                if (truncatedStart.compareTo(truncatedEnd = Value.roundToScale(endBigDecimal, quantityScale, false)) <= 0) {
                    return new Interval(truncatedStart, true, truncatedEnd, true);
                }
                return null;
            }
        }
        if (start instanceof Quantity) {
            Quantity startQuantity = (Quantity)start;
            if (end instanceof Quantity) {
                Quantity truncatedEnd;
                Quantity endQuantity = (Quantity)end;
                int quantityScale = quantity.getValue().scale();
                Quantity truncatedStart = new Quantity().withValue(Value.roundToScale(startQuantity.getValue(), quantityScale, true)).withUnit(startQuantity.getUnit());
                if (truncatedStart.compareTo(truncatedEnd = new Quantity().withValue(Value.roundToScale(endQuantity.getValue(), quantityScale, false)).withUnit(endQuantity.getUnit())) <= 0) {
                    return new Interval(truncatedStart, true, truncatedEnd, true);
                }
                return null;
            }
        }
        if (start instanceof BaseTemporal) {
            BaseTemporal startBaseTemporal = (BaseTemporal)start;
            if (end instanceof BaseTemporal) {
                BaseTemporal truncatedEnd;
                BaseTemporal endBaseTemporal = (BaseTemporal)end;
                Precision precision = Precision.fromString(quantity.getUnit());
                BaseTemporal truncatedStart = startBaseTemporal.roundToPrecision(precision, true);
                if (Boolean.TRUE.equals(LessOrEqualEvaluator.lessOrEqual(truncatedStart, truncatedEnd = endBaseTemporal.roundToPrecision(precision, false), state))) {
                    return new Interval(truncatedStart, true, truncatedEnd, true);
                }
                return null;
            }
        }
        return interval;
    }
}

