/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class TemporalHelper {
    private TemporalHelper() {
    }

    public static String[] normalizeDateTimeElements(int ... elements) {
        String[] ret = new String[elements.length];
        block4: for (int i = 0; i < elements.length; ++i) {
            switch (i) {
                case 0: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 4);
                    continue block4;
                }
                case 6: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 3);
                    continue block4;
                }
                default: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 2);
                }
            }
        }
        return ret;
    }

    public static String[] normalizeTimeElements(int ... elements) {
        String[] ret = new String[elements.length];
        block3: for (int i = 0; i < elements.length; ++i) {
            switch (i) {
                case 3: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 3);
                    continue block3;
                }
                default: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 2);
                }
            }
        }
        return ret;
    }

    public static String addLeadingZeroes(int element, int length) {
        String strElement = Integer.toString(element);
        return StringUtils.repeat((String)"0", (int)(length - strElement.length())) + strElement;
    }

    public static String autoCompleteDateTimeString(String dateString, Precision precision) {
        switch (precision) {
            case YEAR: {
                return dateString + "-01-01T00:00:00.000";
            }
            case MONTH: {
                return dateString + "-01T00:00:00.000";
            }
            case DAY: {
                return dateString + "T00:00:00.000";
            }
            case HOUR: {
                return dateString + ":00:00.000";
            }
            case MINUTE: {
                return dateString + ":00.000";
            }
            case SECOND: {
                return dateString + ".000";
            }
        }
        return dateString;
    }

    public static String autoCompleteDateString(String dateString, Precision precision) {
        switch (precision) {
            case YEAR: {
                return dateString + "-01-01";
            }
            case MONTH: {
                return dateString + "-01";
            }
        }
        return dateString;
    }

    public static String autoCompleteTimeString(String timeString, Precision precision) {
        switch (precision) {
            case HOUR: 
            case MINUTE: {
                return timeString + ":00.000";
            }
            case SECOND: {
                return timeString + ".000";
            }
        }
        return timeString;
    }

    public static int[] cleanArray(Integer ... elements) {
        return Arrays.stream(elements).filter(Objects::nonNull).mapToInt(x -> x).toArray();
    }

    public static BigDecimal zoneToOffset(ZoneOffset zone) {
        int seconds = zone.get(ChronoField.OFFSET_SECONDS);
        return new BigDecimal(Double.toString((float)seconds / 60.0f / 60.0f));
    }

    public static int weeksToDays(int weeks) {
        int years = 0;
        if (weeks >= 52) {
            years = weeks / 52;
            weeks -= years * 52;
        }
        return weeks * 7 + years * 365;
    }

    public static long truncateValueToTargetPrecision(long value, Precision precision, Precision targetPrecision) {
        if (targetPrecision == Precision.YEAR) {
            switch (precision) {
                case YEAR: {
                    return value;
                }
                case MONTH: {
                    return value / 12L;
                }
                case DAY: {
                    return value / 365L;
                }
                case HOUR: {
                    return value / 8760L;
                }
                case MINUTE: {
                    return value / 525600L;
                }
                case SECOND: {
                    return value / 31536000L;
                }
                case MILLISECOND: {
                    return value / 1000L / 3600L / 8760L;
                }
            }
        } else if (targetPrecision == Precision.MONTH) {
            switch (precision) {
                case YEAR: {
                    return value * 12L;
                }
                case MONTH: {
                    return value;
                }
                case DAY: {
                    return value / 30L;
                }
                case HOUR: {
                    return value / 720L;
                }
                case MINUTE: {
                    return value / 43200L;
                }
                case SECOND: {
                    return value / 2592000L;
                }
                case MILLISECOND: {
                    return value / 1000L / 3600L / 720L;
                }
            }
        } else if (targetPrecision == Precision.DAY) {
            switch (precision) {
                case YEAR: {
                    return value * 365L;
                }
                case MONTH: {
                    return value * 12L;
                }
                case DAY: {
                    return value;
                }
                case HOUR: {
                    return value / 24L;
                }
                case MINUTE: {
                    return value / 1440L;
                }
                case SECOND: {
                    return value / 86400L;
                }
                case MILLISECOND: {
                    return value / 1000L / 3600L / 24L;
                }
            }
        } else if (targetPrecision == Precision.HOUR) {
            switch (precision) {
                case YEAR: {
                    return value * 365L * 24L;
                }
                case MONTH: {
                    return value * 30L * 24L;
                }
                case DAY: {
                    return value * 24L;
                }
                case HOUR: {
                    return value;
                }
                case MINUTE: {
                    return value / 60L;
                }
                case SECOND: {
                    return value / 3600L;
                }
                case MILLISECOND: {
                    return value / 1000L / 3600L;
                }
            }
        } else if (targetPrecision == Precision.MINUTE) {
            switch (precision) {
                case YEAR: {
                    return value * 365L * 24L * 60L;
                }
                case MONTH: {
                    return value * 30L * 24L * 60L;
                }
                case DAY: {
                    return value * 24L * 60L;
                }
                case HOUR: {
                    return value * 60L;
                }
                case MINUTE: {
                    return value;
                }
                case SECOND: {
                    return value / 60L;
                }
                case MILLISECOND: {
                    return value / 1000L / 60L;
                }
            }
        } else if (targetPrecision == Precision.SECOND) {
            switch (precision) {
                case YEAR: {
                    return value * 365L * 24L * 60L * 60L;
                }
                case MONTH: {
                    return value * 30L * 24L * 60L * 60L;
                }
                case DAY: {
                    return value * 24L * 60L * 60L;
                }
                case HOUR: {
                    return value * 60L * 60L;
                }
                case MINUTE: {
                    return value * 60L;
                }
                case SECOND: {
                    return value;
                }
                case MILLISECOND: {
                    return value / 1000L;
                }
            }
        } else if (targetPrecision == Precision.MILLISECOND) {
            switch (precision) {
                case YEAR: {
                    return value * 365L * 24L * 60L * 60L * 1000L;
                }
                case MONTH: {
                    return value * 30L * 24L * 60L * 60L;
                }
                case DAY: {
                    return value * 24L * 60L * 60L;
                }
                case HOUR: {
                    return value * 60L * 60L;
                }
                case MINUTE: {
                    return value * 60L;
                }
                case SECOND: {
                    return value;
                }
                case MILLISECOND: {
                    return value / 1000L;
                }
            }
        }
        return 0L;
    }

    public static OffsetDateTime truncateToPrecision(OffsetDateTime dateTime, Precision precision) {
        return switch (precision) {
            case Precision.YEAR -> dateTime.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            case Precision.MONTH -> dateTime.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            case Precision.WEEK -> dateTime.truncatedTo(ChronoUnit.DAYS);
            default -> dateTime.truncatedTo(precision.toChronoUnit());
        };
    }

    public static LocalDate truncateToPrecision(LocalDate date, Precision precision) {
        return switch (precision) {
            case Precision.YEAR -> date.withDayOfYear(1);
            case Precision.MONTH -> date.withDayOfMonth(1);
            default -> date;
        };
    }
}

