/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EquivalentEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToStringEvaluator;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.CqlType;

public class Tuple
implements CqlType {
    protected LinkedHashMap<String, Object> elements;
    private State state;

    public Tuple() {
        this(null);
    }

    public Tuple(State state) {
        this.state = state;
        this.elements = new LinkedHashMap();
    }

    public Object getElement(String key) {
        return this.elements.get(key);
    }

    public HashMap<String, Object> getElements() {
        if (this.elements == null) {
            return new HashMap<String, Object>();
        }
        return this.elements;
    }

    public void setElements(LinkedHashMap<String, Object> elements) {
        for (String entry : elements.keySet()) {
            Objects.requireNonNull(entry, "Tuple keys cannot be null");
        }
        this.elements = elements;
    }

    public Tuple withElements(LinkedHashMap<String, Object> elements) {
        this.setElements(elements);
        return this;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public Boolean equivalent(Object other) {
        if (this.getElements().size() != ((Tuple)other).getElements().size()) {
            return false;
        }
        for (String key : ((Tuple)other).getElements().keySet()) {
            if (this.getElements().containsKey(key)) {
                Boolean areKeyValsSame = EquivalentEvaluator.equivalent(((Tuple)other).getElements().get(key), this.getElements().get(key), this.state);
                if (areKeyValsSame.booleanValue()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Boolean equal(Object other) {
        if (this.getElements().size() != ((Tuple)other).getElements().size()) {
            return false;
        }
        for (String key : ((Tuple)other).getElements().keySet()) {
            if (this.getElements().containsKey(key)) {
                if (((Tuple)other).getElements().get(key) == null && this.getElements().get(key) == null) continue;
                Boolean equal = EqualEvaluator.equal(((Tuple)other).getElements().get(key), this.getElements().get(key), this.state);
                if (equal == null) {
                    return null;
                }
                if (equal.booleanValue()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toPrettyString(this.elements, 0);
    }

    private String toPrettyString(Map<String, Object> tupleElements, int indentLevel) {
        if (tupleElements.isEmpty()) {
            return "Tuple {}";
        }
        StringBuilder sb = new StringBuilder();
        String currentIndent = Tuple.indent(indentLevel);
        String childIndent = Tuple.indent(indentLevel + 1);
        sb.append("Tuple {\n");
        int i = 0;
        int size = tupleElements.size();
        for (Map.Entry<String, Object> entry : tupleElements.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            sb.append(childIndent).append(fieldName).append(": ");
            if (fieldValue instanceof Tuple) {
                sb.append(((Tuple)fieldValue).toPrettyString(((Tuple)fieldValue).elements, indentLevel + 1));
            } else {
                sb.append(ToStringEvaluator.toString(entry.getValue()));
            }
            if (++i >= size) continue;
            sb.append("\n");
        }
        sb.append("\n").append(currentIndent).append("}");
        return sb.toString();
    }

    private static String indent(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

