/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.stream.Stream;
import org.opencds.cqf.cql.engine.elm.executing.MaxValueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MinValueEvaluator;

public class Value {
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    public static final Long MAX_LONG = Long.MAX_VALUE;
    public static final BigDecimal MAX_DECIMAL = new BigDecimal("99999999999999999999.99999999");
    public static final Integer MIN_INT = Integer.MIN_VALUE;
    public static final Long MIN_LONG = Long.MIN_VALUE;
    public static final BigDecimal MIN_DECIMAL = new BigDecimal("-99999999999999999999.99999999");

    private Value() {
    }

    public static BigDecimal verifyPrecision(BigDecimal value, Integer targetScale) {
        if (value.scale() > 8) {
            value = value.setScale(8, RoundingMode.FLOOR);
        }
        if (value.scale() < 0) {
            value = value.setScale(0, RoundingMode.FLOOR);
        }
        if (targetScale != null && value.scale() > targetScale) {
            value = value.stripTrailingZeros();
        }
        return value;
    }

    public static BigDecimal validateDecimal(BigDecimal ret, Integer targetScale) {
        if (ret.compareTo((BigDecimal)MaxValueEvaluator.maxValue("Decimal")) > 0) {
            return null;
        }
        if (ret.compareTo((BigDecimal)MinValueEvaluator.minValue("Decimal")) < 0) {
            return null;
        }
        return Value.verifyPrecision(ret, targetScale);
    }

    public static Integer validateInteger(Integer ret) {
        if (ret > MAX_INT || ret < MIN_INT) {
            return null;
        }
        return ret;
    }

    public static Integer validateInteger(Double ret) {
        if (ret > (double)MAX_INT.intValue() || ret < (double)MIN_INT.intValue()) {
            return null;
        }
        return ret.intValue();
    }

    public static Long validateLong(Long ret) {
        if (ret > MAX_LONG || ret < MIN_LONG) {
            return null;
        }
        return ret;
    }

    public static Long validateLong(Double ret) {
        if (ret > (double)MAX_LONG.longValue() || ret < (double)MIN_LONG.longValue()) {
            return null;
        }
        return ret.longValue();
    }

    public static int getCoarsestScale(Stream<BigDecimal> values) {
        return values.filter(Objects::nonNull).mapToInt(BigDecimal::scale).min().orElse(0);
    }

    public static BigDecimal roundToScale(BigDecimal value, int scale, boolean useCeiling) {
        if (scale < value.scale()) {
            return value.setScale(scale, useCeiling ? RoundingMode.CEILING : RoundingMode.FLOOR);
        }
        return value;
    }
}

