/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.ArrayList;
import java.util.Collections;
import org.opencds.cqf.cql.engine.elm.executing.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OrEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class UnionEvaluator {
    public static Interval unionInterval(Interval left, Interval right, State state) {
        Boolean overlapsOrMeets;
        if (left == null || right == null) {
            return null;
        }
        Object leftStart = left.getStart();
        Object leftEnd = left.getEnd();
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        if (leftStart == null || leftEnd == null || rightStart == null || rightEnd == null) {
            return null;
        }
        String precision = null;
        if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
            precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)leftEnd, (BaseTemporal)rightStart, (BaseTemporal)rightEnd);
        }
        if ((overlapsOrMeets = OrEvaluator.or(OverlapsEvaluator.overlaps(left, right, precision, state), MeetsEvaluator.meets(left, right, precision, state))) == null || !overlapsOrMeets.booleanValue()) {
            return null;
        }
        Object min = LessEvaluator.less(leftStart, rightStart, state) != false ? leftStart : rightStart;
        Object max = GreaterEvaluator.greater(leftEnd, rightEnd, state) != false ? leftEnd : rightEnd;
        return new Interval(min, true, max, true);
    }

    public static Iterable<?> unionIterable(Iterable<?> left, Iterable<?> right, State state) {
        if (left == null && right == null) {
            return Collections.emptyList();
        }
        if (left == null) {
            return DistinctEvaluator.distinct(right, state);
        }
        if (right == null) {
            return DistinctEvaluator.distinct(left, state);
        }
        ArrayList result = new ArrayList();
        for (Object leftElement : left) {
            result.add(leftElement);
        }
        for (Object rightElement : right) {
            result.add(rightElement);
        }
        return DistinctEvaluator.distinct(result, state);
    }

    public static Object union(Object left, Object right, State state) {
        if (left instanceof Interval || right instanceof Interval) {
            return UnionEvaluator.unionInterval((Interval)left, (Interval)right, state);
        }
        if (left instanceof Iterable || right instanceof Iterable) {
            return UnionEvaluator.unionIterable((Iterable)left, (Iterable)right, state);
        }
        String leftName = left != null ? left.getClass().getName() : "<unknown>";
        String rightName = right != null ? right.getClass().getName() : "<unknown>";
        throw new InvalidOperatorArgument("Union(Interval<T>, Interval<T>) or Union(List<T>, List<T>)", String.format("Union(%s, %s)", leftName, rightName));
    }
}

