/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Value;

public class DivideEvaluator {
    private static BigDecimal divideHelper(BigDecimal left, BigDecimal right, State state) {
        if (EqualEvaluator.equal(right, new BigDecimal("0.0"), state).booleanValue()) {
            return null;
        }
        try {
            return Value.verifyPrecision(left.divide(right), null);
        }
        catch (ArithmeticException e) {
            return left.divide(right, 8, RoundingMode.FLOOR);
        }
    }

    public static Object divide(Object left, Object right, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return DivideEvaluator.divideHelper((BigDecimal)left, (BigDecimal)right, state);
        }
        if (left instanceof Quantity && right instanceof Quantity) {
            BigDecimal value = DivideEvaluator.divideHelper(((Quantity)left).getValue(), ((Quantity)right).getValue(), state);
            return new Quantity().withValue(Value.verifyPrecision(value, null)).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof Quantity && right instanceof BigDecimal) {
            BigDecimal value = DivideEvaluator.divideHelper(((Quantity)left).getValue(), (BigDecimal)right, state);
            return new Quantity().withValue(Value.verifyPrecision(value, null)).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(DivideEvaluator.divide(leftInterval.getStart(), rightInterval.getStart(), state), true, DivideEvaluator.divide(leftInterval.getEnd(), rightInterval.getEnd(), state), true);
        }
        throw new InvalidOperatorArgument("Divide(Decimal, Decimal), Divide(Quantity, Decimal), Divide(Quantity, Quantity)", String.format("Divide(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

