/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.AggregateClause;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.ByColumn;
import org.hl7.elm.r1.ByExpression;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.RelationshipClause;
import org.hl7.elm.r1.SortByItem;
import org.hl7.elm.r1.SortClause;
import org.hl7.elm.r1.With;
import org.hl7.elm.r1.Without;
import org.opencds.cqf.cql.engine.elm.executing.AggregateClauseEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DistinctEvaluator;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.Tuple;
import org.opencds.cqf.cql.engine.runtime.iterators.QueryIterator;

public class QueryEvaluator {
    public static Iterable<Object> ensureIterable(Object source) {
        if (source instanceof Iterable) {
            return (Iterable)source;
        }
        ArrayList<Object> sourceList = new ArrayList<Object>();
        if (source != null) {
            sourceList.add(source);
        }
        return sourceList;
    }

    private static void evaluateLets(Query elm, State state, List<Variable> letVariables, ElmLibraryVisitor<Object, State> visitor) {
        for (int i = 0; i < elm.getLet().size(); ++i) {
            letVariables.get(i).setValue(visitor.visitExpression(((LetClause)elm.getLet().get(i)).getExpression(), (Object)state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean evaluateRelationships(Query elm, State state, ElmLibraryVisitor<Object, State> visitor) {
        boolean shouldInclude = true;
        for (RelationshipClause relationship : elm.getRelationship()) {
            boolean hasSatisfyingData = false;
            Iterable<Object> relatedSourceData = QueryEvaluator.ensureIterable(visitor.visitExpression(relationship.getExpression(), (Object)state));
            for (Object relatedElement : relatedSourceData) {
                state.push(new Variable().withName(relationship.getAlias()).withValue(relatedElement));
                try {
                    Object satisfiesRelatedCondition = visitor.visitExpression(relationship.getSuchThat(), (Object)state);
                    if (!(relationship instanceof With) && !(relationship instanceof Without) || !Boolean.TRUE.equals(satisfiesRelatedCondition)) continue;
                    hasSatisfyingData = true;
                    break;
                }
                finally {
                    state.pop();
                }
            }
            if ((!(relationship instanceof With) || hasSatisfyingData) && (!(relationship instanceof Without) || !hasSatisfyingData)) continue;
            shouldInclude = false;
            break;
        }
        return shouldInclude;
    }

    private static boolean evaluateWhere(Query elm, State state, ElmLibraryVisitor<Object, State> visitor) {
        Object satisfiesCondition;
        return elm.getWhere() == null || (satisfiesCondition = visitor.visitExpression(elm.getWhere(), (Object)state)) instanceof Boolean && (Boolean)satisfiesCondition != false;
    }

    private static List<Object> evaluateAggregate(AggregateClause elm, State state, ElmLibraryVisitor<Object, State> visitor, List<Object> elements) {
        return Collections.singletonList(AggregateClauseEvaluator.aggregate(elm, state, visitor, elements));
    }

    private static Object constructTuple(State state, List<Variable> variables) {
        LinkedHashMap<String, Object> elementMap = new LinkedHashMap<String, Object>();
        for (Variable v : variables) {
            elementMap.put(v.getName(), v.getValue());
        }
        return new Tuple(state).withElements(elementMap);
    }

    public static void sortResult(Query elm, List<Object> result, State state, String alias, ElmLibraryVisitor<Object, State> visitor) {
        SortClause sortClause = elm.getSort();
        if (sortClause != null) {
            for (SortByItem byItem : sortClause.getBy()) {
                String direction;
                if (byItem instanceof ByExpression) {
                    result.sort(new CqlList((State)state, visitor, (String)alias, (Expression)((ByExpression)byItem).getExpression()).expressionSort);
                } else if (byItem instanceof ByColumn) {
                    result.sort(new CqlList((State)state, (String)((ByColumn)byItem).getPath()).columnSort);
                } else {
                    result.sort(new CqlList().valueSort);
                }
                if (!(direction = byItem.getDirection().value()).equals("desc") && !direction.equals("descending")) continue;
                Collections.reverse(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internalEvaluate(Query elm, State state, ElmLibraryVisitor<Object, State> visitor) {
        int pushCount;
        if (elm.getAggregate() != null && elm.getReturn() != null) {
            throw new CqlException("aggregate and return are mutually exclusive");
        }
        ArrayList<Iterator<Object>> sources = new ArrayList<Iterator<Object>>();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        ArrayList<Variable> letVariables = new ArrayList<Variable>();
        List<Object> result = new ArrayList<Object>();
        boolean sourceIsList = false;
        try {
            for (AliasedQuerySource source : elm.getSource()) {
                Object obj = visitor.visitExpression(source.getExpression(), (Object)state);
                QuerySource querySource = new QuerySource(source.getAlias(), obj);
                sources.add(querySource.getData().iterator());
                if (querySource.getIsList()) {
                    sourceIsList = true;
                }
                Variable variable = new Variable().withName(source.getAlias());
                variables.add(variable);
                state.push(variable);
                ++pushCount;
            }
            for (LetClause let : elm.getLet()) {
                Variable letVariable = new Variable().withName(let.getIdentifier());
                letVariables.add(letVariable);
                state.push(letVariable);
                ++pushCount;
            }
            QueryIterator iterator = new QueryIterator(state, sources);
            while (iterator.hasNext()) {
                List elements = (List)iterator.next();
                QueryEvaluator.assignVariables(variables, elements);
                QueryEvaluator.evaluateLets(elm, state, letVariables, visitor);
                if (!QueryEvaluator.evaluateRelationships(elm, state, visitor) || !QueryEvaluator.evaluateWhere(elm, state, visitor)) continue;
                if (elm.getReturn() != null) {
                    result.add(visitor.visitExpression(elm.getReturn().getExpression(), (Object)state));
                    continue;
                }
                if (elm.getAggregate() != null || variables.size() > 1) {
                    result.add(QueryEvaluator.constructTuple(state, variables));
                    continue;
                }
                result.add(elements.get(0));
            }
        }
        finally {
            for (pushCount = 0; pushCount > 0; --pushCount) {
                state.pop();
            }
        }
        if (elm.getReturn() != null && elm.getReturn().isDistinct()) {
            result = DistinctEvaluator.distinct(result, state);
        }
        if (elm.getAggregate() != null) {
            result = QueryEvaluator.evaluateAggregate(elm.getAggregate(), state, visitor, result);
        }
        QueryEvaluator.sortResult(elm, result, state, null, visitor);
        if ((result == null || result.isEmpty()) && !sourceIsList) {
            return null;
        }
        return elm.getAggregate() != null || !sourceIsList ? result.get(0) : result;
    }

    private static void assignVariables(List<Variable> variables, List<Object> elements) {
        for (int i = 0; i < variables.size(); ++i) {
            variables.get(i).setValue(elements.get(i));
        }
    }

    static class QuerySource {
        private String alias;
        private boolean isList;
        private Iterable<Object> data;

        public QuerySource(String alias, Object data) {
            this.alias = alias;
            this.isList = data instanceof Iterable;
            this.data = QueryEvaluator.ensureIterable(data);
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean getIsList() {
            return this.isList;
        }

        public Iterable<Object> getData() {
            return this.data;
        }
    }
}

