/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.debug.DebugResult;
import org.opencds.cqf.cql.engine.debug.SourceLocator;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.exception.Severity;
import org.opencds.cqf.cql.engine.execution.Cache;
import org.opencds.cqf.cql.engine.execution.Environment;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Tuple;

public class State {
    private final Cache cache = new Cache();
    private final Environment environment;
    private Deque<String> currentContext = new ArrayDeque<String>();
    private Deque<Deque<Variable>> windows = new ArrayDeque<Deque<Variable>>();
    private Deque<Library> currentLibrary = new ArrayDeque<Library>();
    private Deque<HashSet<Object>> evaluatedResourceStack = new ArrayDeque<HashSet<Object>>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, Object> contextValues = new HashMap<String, Object>();
    private ZonedDateTime evaluationZonedDateTime;
    private DateTime evaluationDateTime;
    private DebugMap debugMap;
    private DebugResult debugResult;

    public State(Environment environment) {
        this.environment = environment;
        this.setEvaluationDateTime(ZonedDateTime.now());
    }

    public Cache getCache() {
        return this.cache;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Library getCurrentLibrary() {
        return this.currentLibrary.peek();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Library library, Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> parameterValue : parameters.entrySet()) {
                this.setParameter(null, parameterValue.getKey(), parameterValue.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String libraryName, String name, Object value) {
        boolean enteredLibrary = this.enterLibrary(libraryName);
        try {
            String fullName = libraryName != null ? String.format("%s.%s", this.getCurrentLibrary().getIdentifier().getId(), name) : name;
            this.parameters.put(fullName, value);
        }
        finally {
            this.exitLibrary(enteredLibrary);
        }
    }

    public boolean enterLibrary(String libraryName) {
        if (libraryName != null) {
            IncludeDef includeDef = Libraries.resolveLibraryRef(libraryName, this.getCurrentLibrary());
            VersionedIdentifier identifier = Libraries.toVersionedIdentifier(includeDef);
            Library library = this.getEnvironment().resolveLibrary(identifier);
            this.currentLibrary.push(library);
            return true;
        }
        return false;
    }

    public void exitLibrary(boolean enteredLibrary) {
        if (enteredLibrary) {
            this.currentLibrary.pop();
        }
    }

    public Map<String, Object> getContextValues() {
        return this.contextValues;
    }

    public void setContextValues(Map<String, Object> contextValues) {
        this.contextValues = contextValues;
    }

    public Deque<Deque<Variable>> getWindows() {
        return this.windows;
    }

    public void setWindows(Deque<Deque<Variable>> windows) {
        this.windows = windows;
    }

    public DebugMap getDebugMap() {
        return this.debugMap;
    }

    public void setDebugMap(DebugMap debugMap) {
        this.debugMap = debugMap;
    }

    public DebugResult getDebugResult() {
        return this.debugResult;
    }

    public DebugAction shouldDebug(Exception e) {
        if (this.debugMap == null) {
            return DebugAction.NONE;
        }
        return this.debugMap.shouldDebug(e);
    }

    public DebugAction shouldDebug(Element node) {
        if (this.debugMap == null) {
            return DebugAction.NONE;
        }
        return this.debugMap.shouldDebug(node, this.getCurrentLibrary());
    }

    private void ensureDebugResult() {
        if (this.debugResult == null) {
            this.debugResult = new DebugResult();
        }
    }

    public void setEvaluationDateTime(ZonedDateTime evaluationZonedDateTime) {
        this.evaluationZonedDateTime = evaluationZonedDateTime;
        this.evaluationDateTime = new DateTime(evaluationZonedDateTime.toOffsetDateTime());
    }

    public ZonedDateTime getEvaluationZonedDateTime() {
        return this.evaluationZonedDateTime;
    }

    public DateTime getEvaluationDateTime() {
        return this.evaluationDateTime;
    }

    public void init(Library library) {
        this.pushWindow();
        this.currentLibrary.push(library);
        this.pushEvaluatedResourceStack();
    }

    public void pop() {
        if (!this.windows.peek().isEmpty()) {
            this.getStack().pop();
        }
    }

    public void push(Variable variable) {
        this.getStack().push(variable);
    }

    public Variable resolveVariable(String name) {
        for (Deque<Variable> window : this.windows) {
            for (Variable v : window) {
                if (!v.getName().equals(name)) continue;
                return v;
            }
        }
        return null;
    }

    public Variable resolveVariable(String name, boolean mustResolve) {
        Variable result = this.resolveVariable(name);
        if (mustResolve && result == null) {
            throw new CqlException(String.format("Could not resolve variable reference %s", name));
        }
        return result;
    }

    public void pushWindow() {
        this.windows.push(new ArrayDeque());
    }

    public void popWindow() {
        this.windows.pop();
    }

    private Deque<Variable> getStack() {
        return this.windows.peek();
    }

    public void setContextValue(String context, Object contextValue) {
        if (!this.contextValues.containsKey(context) || !this.contextValues.get(context).equals(contextValue)) {
            this.contextValues.put(context, contextValue);
            this.cache.getExpressions().clear();
        }
    }

    public boolean enterContext(String context) {
        if (context != null) {
            this.currentContext.push(context);
            return true;
        }
        return false;
    }

    public void exitContext(boolean isEnteredContext) {
        if (isEnteredContext) {
            this.currentContext.pop();
        }
    }

    public String getCurrentContext() {
        if (this.currentContext.isEmpty()) {
            return null;
        }
        return this.currentContext.peekFirst();
    }

    public Object getCurrentContextValue() {
        String context = this.getCurrentContext();
        if (context != null && this.contextValues.containsKey(context)) {
            return this.contextValues.get(context);
        }
        return null;
    }

    public Set<Object> getEvaluatedResources() {
        if (this.evaluatedResourceStack.isEmpty()) {
            throw new IllegalStateException("Attempted to get the evaluatedResource stack when it's empty");
        }
        return this.evaluatedResourceStack.peek();
    }

    public void clearEvaluatedResources() {
        this.evaluatedResourceStack.clear();
        this.pushEvaluatedResourceStack();
    }

    public void pushEvaluatedResourceStack() {
        this.evaluatedResourceStack.push(new HashSet());
    }

    public void popEvaluatedResourceStack() {
        if (this.evaluatedResourceStack.isEmpty()) {
            throw new IllegalStateException("Attempted to pop the evaluatedResource stack when it's empty");
        }
        if (this.evaluatedResourceStack.size() == 1) {
            throw new IllegalStateException("Attempted to pop the evaluatedResource stack when only the root remains");
        }
        Set objects = this.evaluatedResourceStack.pop();
        HashSet<Object> set = this.evaluatedResourceStack.peek();
        set.addAll(objects);
    }

    public Object resolveAlias(String name) {
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean isList = false;
        for (Variable v : this.getStack()) {
            if (!v.getName().equals(name)) continue;
            if (v.isList()) {
                isList = true;
            }
            ret.add(v.getValue());
        }
        return isList ? ret : ret.get(ret.size() - 1);
    }

    public Object resolveIdentifierRef(String name) {
        for (Deque<Variable> window : this.windows) {
            for (Variable v : window) {
                Object value = v.getValue();
                if (value instanceof Tuple) {
                    for (String key : ((Tuple)value).getElements().keySet()) {
                        if (!key.equals(name)) continue;
                        return ((Tuple)value).getElements().get(key);
                    }
                }
                try {
                    return this.environment.resolvePath(value, name);
                }
                catch (Exception exception) {
                }
            }
        }
        throw new CqlException("Cannot resolve identifier " + name);
    }

    public void logDebugResult(Element node, Object result, DebugAction action) {
        this.ensureDebugResult();
        this.debugResult.logDebugResult(node, this.getCurrentLibrary(), result, action);
    }

    public void logDebugMessage(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.MESSAGE));
    }

    public void logDebugWarning(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.WARNING));
    }

    public void logDebugTrace(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.TRACE));
    }

    public void logDebugError(CqlException e) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(e);
    }
}

