/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.AggregateClause;
import org.opencds.cqf.cql.engine.elm.executing.DistinctEvaluator;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.Tuple;

public class AggregateClauseEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object aggregate(AggregateClause elm, State state, ElmLibraryVisitor<Object, State> visitor, List<Object> elements) {
        Objects.requireNonNull(elm, "elm can not be null");
        Objects.requireNonNull(visitor, "visitor can not be null");
        Objects.requireNonNull(elements, "elements can not be null");
        Objects.requireNonNull(state, "state can not be null");
        if (elm.isDistinct()) {
            elements = DistinctEvaluator.distinct(elements, state);
        }
        Object aggregatedValue = null;
        if (elm.getStarting() != null) {
            aggregatedValue = visitor.visitExpression(elm.getStarting(), (Object)state);
        }
        for (Object e : elements) {
            if (!(e instanceof Tuple)) {
                throw new CqlException("expected aggregation source to be a Tuple");
            }
            Tuple tuple = (Tuple)e;
            int pushes = 0;
            try {
                state.push(new Variable().withName(elm.getIdentifier()).withValue(aggregatedValue));
                ++pushes;
                for (Map.Entry<String, Object> p : tuple.getElements().entrySet()) {
                    state.push(new Variable().withName(p.getKey()).withValue(p.getValue()));
                    ++pushes;
                }
                aggregatedValue = visitor.visitExpression(elm.getExpression(), (Object)state);
            }
            finally {
                while (pushes > 0) {
                    state.pop();
                    --pushes;
                }
            }
        }
        return aggregatedValue;
    }
}

