/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.cqframework.cql.elm.visiting.ElmBaseLibraryVisitor;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.elm.r1.Abs;
import org.hl7.elm.r1.Add;
import org.hl7.elm.r1.After;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AllTrue;
import org.hl7.elm.r1.And;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.AnyTrue;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.Avg;
import org.hl7.elm.r1.Before;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CalculateAgeAt;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.Ceiling;
import org.hl7.elm.r1.Children;
import org.hl7.elm.r1.Coalesce;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.Collapse;
import org.hl7.elm.r1.Combine;
import org.hl7.elm.r1.Concatenate;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Contains;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.ConvertQuantity;
import org.hl7.elm.r1.ConvertsToBoolean;
import org.hl7.elm.r1.ConvertsToDate;
import org.hl7.elm.r1.ConvertsToDateTime;
import org.hl7.elm.r1.ConvertsToDecimal;
import org.hl7.elm.r1.ConvertsToInteger;
import org.hl7.elm.r1.ConvertsToLong;
import org.hl7.elm.r1.ConvertsToQuantity;
import org.hl7.elm.r1.ConvertsToString;
import org.hl7.elm.r1.ConvertsToTime;
import org.hl7.elm.r1.Count;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateFrom;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimeComponentFrom;
import org.hl7.elm.r1.Descendents;
import org.hl7.elm.r1.DifferenceBetween;
import org.hl7.elm.r1.Distinct;
import org.hl7.elm.r1.Divide;
import org.hl7.elm.r1.DurationBetween;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Ends;
import org.hl7.elm.r1.EndsWith;
import org.hl7.elm.r1.Equal;
import org.hl7.elm.r1.Equivalent;
import org.hl7.elm.r1.Except;
import org.hl7.elm.r1.Exists;
import org.hl7.elm.r1.Exp;
import org.hl7.elm.r1.Expand;
import org.hl7.elm.r1.ExpandValueSet;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.Filter;
import org.hl7.elm.r1.First;
import org.hl7.elm.r1.Flatten;
import org.hl7.elm.r1.Floor;
import org.hl7.elm.r1.ForEach;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.GeometricMean;
import org.hl7.elm.r1.Greater;
import org.hl7.elm.r1.GreaterOrEqual;
import org.hl7.elm.r1.HighBoundary;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.Implies;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludedIn;
import org.hl7.elm.r1.Includes;
import org.hl7.elm.r1.IndexOf;
import org.hl7.elm.r1.Indexer;
import org.hl7.elm.r1.Instance;
import org.hl7.elm.r1.Intersect;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.IsFalse;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.IsTrue;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.LastPositionOf;
import org.hl7.elm.r1.Length;
import org.hl7.elm.r1.Less;
import org.hl7.elm.r1.LessOrEqual;
import org.hl7.elm.r1.List;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Ln;
import org.hl7.elm.r1.Log;
import org.hl7.elm.r1.LowBoundary;
import org.hl7.elm.r1.Lower;
import org.hl7.elm.r1.Matches;
import org.hl7.elm.r1.Max;
import org.hl7.elm.r1.MaxValue;
import org.hl7.elm.r1.Median;
import org.hl7.elm.r1.Meets;
import org.hl7.elm.r1.MeetsAfter;
import org.hl7.elm.r1.MeetsBefore;
import org.hl7.elm.r1.Message;
import org.hl7.elm.r1.Min;
import org.hl7.elm.r1.MinValue;
import org.hl7.elm.r1.Mode;
import org.hl7.elm.r1.Modulo;
import org.hl7.elm.r1.Multiply;
import org.hl7.elm.r1.Negate;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.NotEqual;
import org.hl7.elm.r1.Now;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.Or;
import org.hl7.elm.r1.Overlaps;
import org.hl7.elm.r1.OverlapsAfter;
import org.hl7.elm.r1.OverlapsBefore;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.PointFrom;
import org.hl7.elm.r1.PopulationStdDev;
import org.hl7.elm.r1.PopulationVariance;
import org.hl7.elm.r1.PositionOf;
import org.hl7.elm.r1.Power;
import org.hl7.elm.r1.Precision;
import org.hl7.elm.r1.Predecessor;
import org.hl7.elm.r1.Product;
import org.hl7.elm.r1.ProperContains;
import org.hl7.elm.r1.ProperIn;
import org.hl7.elm.r1.ProperIncludedIn;
import org.hl7.elm.r1.ProperIncludes;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.Ratio;
import org.hl7.elm.r1.Repeat;
import org.hl7.elm.r1.ReplaceMatches;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.Round;
import org.hl7.elm.r1.SameAs;
import org.hl7.elm.r1.SameOrAfter;
import org.hl7.elm.r1.SameOrBefore;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.Size;
import org.hl7.elm.r1.Slice;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.SplitOnMatches;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.Starts;
import org.hl7.elm.r1.StartsWith;
import org.hl7.elm.r1.StdDev;
import org.hl7.elm.r1.Substring;
import org.hl7.elm.r1.Subtract;
import org.hl7.elm.r1.Successor;
import org.hl7.elm.r1.Sum;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.TimeFrom;
import org.hl7.elm.r1.TimeOfDay;
import org.hl7.elm.r1.TimezoneFrom;
import org.hl7.elm.r1.TimezoneOffsetFrom;
import org.hl7.elm.r1.ToBoolean;
import org.hl7.elm.r1.ToConcept;
import org.hl7.elm.r1.ToDate;
import org.hl7.elm.r1.ToDateTime;
import org.hl7.elm.r1.ToDecimal;
import org.hl7.elm.r1.ToInteger;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.ToLong;
import org.hl7.elm.r1.ToQuantity;
import org.hl7.elm.r1.ToRatio;
import org.hl7.elm.r1.ToString;
import org.hl7.elm.r1.ToTime;
import org.hl7.elm.r1.Today;
import org.hl7.elm.r1.Truncate;
import org.hl7.elm.r1.TruncatedDivide;
import org.hl7.elm.r1.Tuple;
import org.hl7.elm.r1.TupleElement;
import org.hl7.elm.r1.Union;
import org.hl7.elm.r1.Upper;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.Variance;
import org.hl7.elm.r1.Width;
import org.hl7.elm.r1.Xor;
import org.opencds.cqf.cql.engine.elm.executing.AbsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AddEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AliasRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AllTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AnyInCodeSystemEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AnyInValueSetEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AvgEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CalculateAgeAtEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CalculateAgeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CeilingEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ChildrenEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CoalesceEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CodeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CodeRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CodeSystemRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CollapseEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CombineEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConcatenateEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConceptEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConceptRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ContainsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertQuantityEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToBooleanEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToDateEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToDateTimeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToDecimalEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToIntegerEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToLongEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToQuantityEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToStringEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ConvertsToTimeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.CountEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DateEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DateFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DateTimeComponentFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DateTimeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DescendentsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DifferenceBetweenEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DivideEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DurationBetweenEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EndsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EndsWithEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EquivalentEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExceptEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExistsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExpEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExpandEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExpandValueSetEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExpressionDefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ExpressionRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.FilterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.FirstEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.FlattenEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.FloorEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ForEachEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.FunctionRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GeometricMeanEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.HighBoundaryEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IdentifierRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IfEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ImpliesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InCodeSystemEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InValueSetEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IncludedInEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IncludesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IndexOfEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IndexerEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InstanceEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IntersectEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IntervalEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IsFalseEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IsNullEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IsTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LastEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LastPositionOfEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LengthEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ListEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LiteralEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LnEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LogEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LowBoundaryEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LowerEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MatchesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MaxEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MaxValueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MedianEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsBeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MeetsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MessageEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MinEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MinValueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ModeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ModuloEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MultiplyEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NegateEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NotEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NotEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NowEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NullEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OperandRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OrEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OverlapsAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OverlapsBeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ParameterRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PointFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PopulationStdDevEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PopulationVarianceEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PositionOfEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PowerEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PrecisionEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PredecessorEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProductEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProperContainsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProperInEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProperIncludedInEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProperIncludesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PropertyEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.QuantityEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.QueryEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.QueryLetRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.RatioEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.RepeatEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ReplaceMatchesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.RetrieveEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.RoundEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SingletonFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SizeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SliceEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SplitEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SplitOnMatchesEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.StartEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.StartsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.StartsWithEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.StdDevEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SubstringEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SubtractEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SumEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TimeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TimeFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TimeOfDayEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TimezoneFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TimezoneOffsetFromEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToBooleanEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToConceptEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToDateEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToDateTimeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToDecimalEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToIntegerEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToListEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToLongEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToQuantityEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToRatioEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToStringEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToTimeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TodayEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TruncateEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TruncatedDivideEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.TupleEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.UnionEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.UpperEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ValueSetRefEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.VarianceEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.WidthEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.XorEvaluator;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;

public class EvaluationVisitor
extends ElmBaseLibraryVisitor<Object, State> {
    public Object visitExpressionDef(ExpressionDef expressionDef, State state) {
        return ExpressionDefEvaluator.internalEvaluate(expressionDef, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitExpressionRef(ExpressionRef expressionRef, State state) {
        return ExpressionRefEvaluator.internalEvaluate(expressionRef, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitFunctionRef(FunctionRef elm, State state) {
        return FunctionRefEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitAdd(Add add, State state) {
        Object left = this.visitExpression((Expression)add.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)add.getOperand().get(1), state);
        return AddEvaluator.add(left, right);
    }

    public Object visitAbs(Abs abs, State state) {
        Object operand = this.visitExpression(abs.getOperand(), state);
        return AbsEvaluator.abs(operand);
    }

    public Object visitAfter(After after, State state) {
        Object left = this.visitExpression((Expression)after.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)after.getOperand().get(1), state);
        String precision = after.getPrecision() == null ? null : after.getPrecision().value();
        return AfterEvaluator.after(left, right, precision, state);
    }

    public Object visitAliasRef(AliasRef aliasRef, State state) {
        return AliasRefEvaluator.internalEvaluate(aliasRef.getName(), state);
    }

    public Object visitAllTrue(AllTrue allTrue, State state) {
        Object src = this.visitExpression(allTrue.getSource(), state);
        return AllTrueEvaluator.allTrue(src);
    }

    public Object visitAnd(And and, State state) {
        Object left = this.visitExpression((Expression)and.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)and.getOperand().get(1), state);
        return AndEvaluator.and(left, right);
    }

    public Object visitAnyInCodeSystem(AnyInCodeSystem anyInCodeSystem, State state) {
        Object codes = this.visitExpression(anyInCodeSystem.getCodes(), state);
        Object codeSystem = this.visitExpression(anyInCodeSystem.getCodesystemExpression(), state);
        return AnyInCodeSystemEvaluator.internalEvaluate(codes, anyInCodeSystem.getCodesystem(), codeSystem, state);
    }

    public Object visitInCodeSystem(InCodeSystem inCodeSystem, State state) {
        Object code = this.visitExpression(inCodeSystem.getCode(), state);
        Object cs = null;
        if (inCodeSystem.getCodesystem() != null) {
            cs = CodeSystemRefEvaluator.toCodeSystem(inCodeSystem.getCodesystem(), state);
        } else if (inCodeSystem.getCodesystemExpression() != null) {
            cs = this.visitExpression(inCodeSystem.getCodesystemExpression(), state);
        }
        return InCodeSystemEvaluator.inCodeSystem(code, cs, state);
    }

    public Object visitAnyInValueSet(AnyInValueSet anyInValueSet, State state) {
        Object codes = this.visitExpression(anyInValueSet.getCodes(), state);
        Object valueset = this.visitExpression(anyInValueSet.getValuesetExpression(), state);
        return AnyInValueSetEvaluator.internalEvaluate(codes, anyInValueSet.getValueset(), valueset, state);
    }

    public Object visitInValueSet(InValueSet inValueSet, State state) {
        Object code = this.visitExpression(inValueSet.getCode(), state);
        Object vs = null;
        if (inValueSet.getValueset() != null) {
            vs = ValueSetRefEvaluator.toValueSet(state, inValueSet.getValueset());
        } else if (inValueSet.getValuesetExpression() != null) {
            vs = this.visitExpression(inValueSet.getValuesetExpression(), state);
        }
        return InValueSetEvaluator.inValueSet(code, vs, state);
    }

    public Object visitValueSetRef(ValueSetRef elm, State state) {
        return ValueSetRefEvaluator.internalEvaluate(state, elm);
    }

    public Object visitXor(Xor elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return XorEvaluator.xor(left, right);
    }

    public Object visitWidth(Width elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return WidthEvaluator.width(operand);
    }

    public Object visitVariance(Variance variance, State state) {
        Object source = this.visitExpression(variance.getSource(), state);
        return VarianceEvaluator.variance(source, state);
    }

    public Object visitAvg(Avg avg, State state) {
        Object src = this.visitExpression(avg.getSource(), state);
        return AvgEvaluator.avg(src, state);
    }

    public Object visitDivide(Divide elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return DivideEvaluator.divide(left, right, state);
    }

    public Object visitUpper(Upper elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return UpperEvaluator.upper(operand);
    }

    public Object visitUnion(Union elm, State state) {
        Expression left = (Expression)elm.getOperand().get(0);
        Expression right = (Expression)elm.getOperand().get(1);
        Object leftResult = this.visitExpression(left, state);
        Object rightResult = this.visitExpression(right, state);
        if (left.getResultType() instanceof ListType || right.getResultType() instanceof ListType || elm.getResultType() instanceof ListType) {
            return UnionEvaluator.unionIterable((Iterable)leftResult, (Iterable)rightResult, state);
        }
        if (left.getResultType() instanceof IntervalType || right.getResultType() instanceof IntervalType || elm.getResultType() instanceof IntervalType) {
            return UnionEvaluator.unionInterval((org.opencds.cqf.cql.engine.runtime.Interval)leftResult, (org.opencds.cqf.cql.engine.runtime.Interval)rightResult, state);
        }
        return UnionEvaluator.union(left, right, state);
    }

    public Object visitGreater(Greater elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return GreaterEvaluator.greater(left, right, state);
    }

    public Object visitMeets(Meets elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return MeetsEvaluator.meets(left, right, precision, state);
    }

    public Object visitDistinct(Distinct elm, State state) {
        Object value = this.visitExpression(elm.getOperand(), state);
        return DistinctEvaluator.distinct((Iterable)value, state);
    }

    public Object visitMeetsAfter(MeetsAfter elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return MeetsAfterEvaluator.meetsAfter(left, right, precision, state);
    }

    public Object visitMeetsBefore(MeetsBefore elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return MeetsBeforeEvaluator.meetsBefore(left, right, precision, state);
    }

    public Object visitSameAs(SameAs elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return SameAsEvaluator.sameAs(left, right, precision, state);
    }

    public Object visitSameOrAfter(SameOrAfter elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return SameOrAfterEvaluator.sameOrAfter(left, right, precision, state);
    }

    public Object visitSameOrBefore(SameOrBefore elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return SameOrBeforeEvaluator.sameOrBefore(left, right, precision, state);
    }

    public Object visitGreaterOrEqual(GreaterOrEqual elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return GreaterOrEqualEvaluator.greaterOrEqual(left, right, state);
    }

    public Object visitSingletonFrom(SingletonFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return SingletonFromEvaluator.singletonFrom(operand);
    }

    public Object visitSize(Size elm, State state) {
        Object argument = this.visitExpression(elm.getOperand(), state);
        return SizeEvaluator.size(argument);
    }

    public Object visitSlice(Slice elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        Integer start = (Integer)this.visitExpression(elm.getStartIndex(), state);
        Integer end = elm.getEndIndex() == null ? null : (Integer)this.visitExpression(elm.getEndIndex(), state);
        return SliceEvaluator.slice(source, start, end);
    }

    public Object visitSplit(Split elm, State state) {
        Object stringToSplit = this.visitExpression(elm.getStringToSplit(), state);
        Object separator = this.visitExpression(elm.getSeparator(), state);
        return SplitEvaluator.split(stringToSplit, separator);
    }

    public Object visitSplitOnMatches(SplitOnMatches elm, State state) {
        Object stringToSplit = this.visitExpression(elm.getStringToSplit(), state);
        Object separator = this.visitExpression(elm.getSeparatorPattern(), state);
        return SplitOnMatchesEvaluator.splitOnMatches(stringToSplit, separator);
    }

    public Object visitStart(Start elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return StartEvaluator.start(operand);
    }

    public Object visitStarts(Starts elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return StartsEvaluator.starts(left, right, precision, state);
    }

    public Object visitStartsWith(StartsWith elm, State state) {
        Object argument = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object prefix = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return StartsWithEvaluator.startsWith(argument, prefix);
    }

    public Object visitStdDev(StdDev elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return StdDevEvaluator.stdDev(source, state);
    }

    public Object visitSubstring(Substring elm, State state) {
        Object stringValue = this.visitExpression(elm.getStringToSub(), state);
        Object startIndexValue = this.visitExpression(elm.getStartIndex(), state);
        Object lengthValue = elm.getLength() == null ? null : this.visitExpression(elm.getLength(), state);
        return SubstringEvaluator.substring(stringValue, startIndexValue, lengthValue);
    }

    public Object visitSubtract(Subtract elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return SubtractEvaluator.subtract(left, right);
    }

    public Object visitSuccessor(Successor elm, State state) {
        Object value = this.visitExpression(elm.getOperand(), state);
        return SuccessorEvaluator.successor(value);
    }

    public Object visitSum(Sum elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return SumEvaluator.sum(source);
    }

    public Object visitTime(Time elm, State state) {
        if (elm.getHour() == null) {
            return null;
        }
        Integer hour = elm.getHour() == null ? null : (Integer)this.visitExpression(elm.getHour(), state);
        Integer minute = elm.getMinute() == null ? null : (Integer)this.visitExpression(elm.getMinute(), state);
        Integer second = elm.getSecond() == null ? null : (Integer)this.visitExpression(elm.getSecond(), state);
        Integer miliSecond = elm.getMillisecond() == null ? null : (Integer)this.visitExpression(elm.getMillisecond(), state);
        return TimeEvaluator.time(hour, minute, second, miliSecond);
    }

    public Object visitTimeFrom(TimeFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return TimeFromEvaluator.timeFrom(operand);
    }

    public Object visitTimeOfDay(TimeOfDay elm, State state) {
        return TimeOfDayEvaluator.internalEvaluate(state);
    }

    public Object visitTimezoneFrom(TimezoneFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return TimezoneFromEvaluator.internalEvaluate(operand);
    }

    public Object visitTimezoneOffsetFrom(TimezoneOffsetFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return TimezoneOffsetFromEvaluator.timezoneOffsetFrom(operand);
    }

    public Object visitToBoolean(ToBoolean elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToBooleanEvaluator.toBoolean(operand);
    }

    public Object visitToConcept(ToConcept elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToConceptEvaluator.toConcept(operand);
    }

    public Object visitToDate(ToDate elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToDateEvaluator.toDate(operand);
    }

    public Object visitToDateTime(ToDateTime elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToDateTimeEvaluator.ToDateTime(operand, state);
    }

    public Object visitToday(Today elm, State state) {
        return TodayEvaluator.today(state);
    }

    public Object visitToDecimal(ToDecimal elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToDecimalEvaluator.toDecimal(operand);
    }

    public Object visitToInteger(ToInteger elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToIntegerEvaluator.toInteger(operand);
    }

    public Object visitToList(ToList elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToListEvaluator.toList(operand);
    }

    public Object visitToLong(ToLong elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToLongEvaluator.toLong(operand);
    }

    public Object visitToQuantity(ToQuantity elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToQuantityEvaluator.toQuantity(operand, state);
    }

    public Object visitToRatio(ToRatio elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToRatioEvaluator.toRatio(operand);
    }

    public Object visitToString(ToString elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToStringEvaluator.toString(operand);
    }

    public Object visitToTime(ToTime elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ToTimeEvaluator.toTime(operand);
    }

    public Object visitTruncatedDivide(TruncatedDivide elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return TruncatedDivideEvaluator.div(left, right, state);
    }

    public Object visitMedian(Median elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return MedianEvaluator.median(source, state);
    }

    public Object visitTruncate(Truncate elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return TruncateEvaluator.truncate(operand);
    }

    public Object visitTuple(Tuple elm, State state) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (TupleElement element : elm.getElement()) {
            ret.put(element.getName(), this.visitExpression(element.getValue(), state));
        }
        return TupleEvaluator.internalEvaluate(ret, state);
    }

    public Object visitAnyTrue(AnyTrue elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return AnyTrueEvaluator.anyTrue(source);
    }

    public Object visitAs(As elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return AsEvaluator.internalEvaluate(operand, elm, elm.isStrict(), state);
    }

    public Object visitBefore(Before elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return BeforeEvaluator.before(left, right, precision, state);
    }

    public Object visitCalculateAgeAt(CalculateAgeAt elm, State state) {
        Object birthDate = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object asOf = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision().value();
        return CalculateAgeAtEvaluator.calculateAgeAt(birthDate, asOf, precision);
    }

    public Object visitCalculateAge(CalculateAge elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        String precision = elm.getPrecision().value();
        return CalculateAgeEvaluator.internalEvaluate(operand, precision, state);
    }

    public Object visitCase(Case elm, State state) {
        if (elm.getComparand() == null) {
            for (CaseItem caseItem : elm.getCaseItem()) {
                Boolean when = (Boolean)this.visitExpression(caseItem.getWhen(), state);
                if (when == null || !when.booleanValue()) continue;
                return this.visitExpression(caseItem.getThen(), state);
            }
            return this.visitElement((Element)elm.getElse(), state);
        }
        Object comparand = this.visitExpression(elm.getComparand(), state);
        for (CaseItem caseItem : elm.getCaseItem()) {
            Object when = this.visitExpression(caseItem.getWhen(), state);
            Boolean check = EquivalentEvaluator.equivalent(comparand, when, state);
            if (check == null || !check.booleanValue()) continue;
            return this.visitElement((Element)caseItem.getThen(), state);
        }
        return this.visitElement((Element)elm.getElse(), state);
    }

    public Object visitCeiling(Ceiling elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return CeilingEvaluator.ceiling(operand);
    }

    public Object visitChildren(Children elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return ChildrenEvaluator.children(source);
    }

    public Object visitCoalesce(Coalesce elm, State state) {
        ArrayList<Object> operands = new ArrayList<Object>();
        for (Expression operand : elm.getOperand()) {
            operands.add(this.visitExpression(operand, state));
        }
        return CoalesceEvaluator.coalesce(operands);
    }

    public Object visitCode(Code elm, State state) {
        return CodeEvaluator.internalEvaluate(elm.getSystem(), elm.getCode(), elm.getDisplay(), state);
    }

    public Object visitCodeRef(CodeRef elm, State state) {
        return CodeRefEvaluator.toCode(elm, state);
    }

    public Object visitConcept(Concept elm, State state) {
        ArrayList<org.opencds.cqf.cql.engine.runtime.Code> codes = new ArrayList<org.opencds.cqf.cql.engine.runtime.Code>();
        for (int i = 0; i < elm.getCode().size(); ++i) {
            codes.add((org.opencds.cqf.cql.engine.runtime.Code)this.visitExpression((Expression)elm.getCode().get(i), state));
        }
        return ConceptEvaluator.internalEvaluate(codes, elm.getDisplay());
    }

    public Object visitConceptRef(ConceptRef elm, State state) {
        return ConceptRefEvaluator.toConcept(elm, state);
    }

    public Object visitCollapse(Collapse elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        Iterable list = (Iterable)left;
        Quantity per = (Quantity)right;
        return CollapseEvaluator.collapse(list, per, state);
    }

    public Object visitCombine(Combine elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        String separator = elm.getSeparator() == null ? "" : (String)this.visitExpression(elm.getSeparator(), state);
        return CombineEvaluator.combine(source, separator);
    }

    public Object visitConcatenate(Concatenate elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return ConcatenateEvaluator.concatenate(left, right);
    }

    public Object visitContains(Contains elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return ContainsEvaluator.internalEvaluate(left, right, elm.getOperand().get(0), precision, state);
    }

    public Object visitConvert(Convert elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertEvaluator.internalEvaluate(operand, elm.getToType(), elm.getToTypeSpecifier(), state);
    }

    public Object visitConvertQuantity(ConvertQuantity elm, State state) {
        Object argument = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object unit = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return ConvertQuantityEvaluator.convertQuantity(argument, unit, state.getEnvironment().getLibraryManager().getUcumService());
    }

    public Object visitConvertsToBoolean(ConvertsToBoolean elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToBooleanEvaluator.convertsToBoolean(operand);
    }

    public Object visitConvertsToDate(ConvertsToDate elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToDateEvaluator.convertsToDate(operand);
    }

    public Object visitConvertsToDateTime(ConvertsToDateTime elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToDateTimeEvaluator.convertsToDateTime(operand, state.getEvaluationDateTime().getZoneOffset());
    }

    public Object visitConvertsToDecimal(ConvertsToDecimal elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToDecimalEvaluator.convertsToDecimal(operand);
    }

    public Object visitConvertsToInteger(ConvertsToInteger elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToIntegerEvaluator.convertsToInteger(operand);
    }

    public Object visitConvertsToLong(ConvertsToLong elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToLongEvaluator.convertsToLong(operand);
    }

    public Object visitConvertsToQuantity(ConvertsToQuantity elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToQuantityEvaluator.convertsToQuantity(operand, state);
    }

    public Object visitConvertsToString(ConvertsToString elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToStringEvaluator.convertsToString(operand);
    }

    public Object visitConvertsToTime(ConvertsToTime elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ConvertsToTimeEvaluator.convertsToTime(operand);
    }

    public Object visitCount(Count elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return CountEvaluator.count(source);
    }

    public Object visitDate(Date elm, State state) {
        Integer year = elm.getYear() == null ? null : (Integer)this.visitExpression(elm.getYear(), state);
        Integer month = elm.getMonth() == null ? null : (Integer)this.visitExpression(elm.getMonth(), state);
        Integer day = elm.getDay() == null ? null : (Integer)this.visitExpression(elm.getDay(), state);
        return DateEvaluator.internalEvaluate(year, month, day);
    }

    public Object visitDateFrom(DateFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return DateFromEvaluator.dateFrom(operand);
    }

    public Object visitDateTimeComponentFrom(DateTimeComponentFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        String precision = elm.getPrecision().value();
        return DateTimeComponentFromEvaluator.dateTimeComponentFrom(operand, precision);
    }

    public Object visitDateTime(DateTime elm, State state) {
        Integer year = elm.getYear() == null ? null : (Integer)this.visitExpression(elm.getYear(), state);
        Integer month = elm.getMonth() == null ? null : (Integer)this.visitExpression(elm.getMonth(), state);
        Integer day = elm.getDay() == null ? null : (Integer)this.visitExpression(elm.getDay(), state);
        Integer hour = elm.getHour() == null ? null : (Integer)this.visitExpression(elm.getHour(), state);
        Integer minute = elm.getMinute() == null ? null : (Integer)this.visitExpression(elm.getMinute(), state);
        Integer second = elm.getSecond() == null ? null : (Integer)this.visitExpression(elm.getSecond(), state);
        Integer milliSecond = elm.getMillisecond() == null ? null : (Integer)this.visitExpression(elm.getMillisecond(), state);
        BigDecimal timeZoneOffset = elm.getTimezoneOffset() == null ? TemporalHelper.zoneToOffset(state.getEvaluationDateTime().getZoneOffset()) : (BigDecimal)this.visitExpression(elm.getTimezoneOffset(), state);
        return DateTimeEvaluator.internalEvaluate(year, month, day, hour, minute, second, milliSecond, timeZoneOffset);
    }

    public Object visitDescendents(Descendents elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return DescendentsEvaluator.descendents(source);
    }

    public Object visitDifferenceBetween(DifferenceBetween elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision().value();
        return DifferenceBetweenEvaluator.difference(left, right, org.opencds.cqf.cql.engine.runtime.Precision.fromString(precision));
    }

    public Object visitDurationBetween(DurationBetween elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision().value();
        return DurationBetweenEvaluator.duration(left, right, org.opencds.cqf.cql.engine.runtime.Precision.fromString(precision));
    }

    public Object visitEnd(End elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return EndEvaluator.end(operand);
    }

    public Object visitEnds(Ends elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return EndsEvaluator.ends(left, right, precision, state);
    }

    public Object visitEndsWith(EndsWith elm, State state) {
        String argument = (String)this.visitExpression((Expression)elm.getOperand().get(0), state);
        String suffix = (String)this.visitExpression((Expression)elm.getOperand().get(1), state);
        return EndsWithEvaluator.endsWith(argument, suffix);
    }

    public Object visitEqual(Equal elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return EqualEvaluator.equal(left, right, state);
    }

    public Object visitEquivalent(Equivalent elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return EquivalentEvaluator.equivalent(left, right, state);
    }

    public Object visitExcept(Except elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return ExceptEvaluator.except(left, right, state);
    }

    public Object visitExists(Exists elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ExistsEvaluator.exists(operand);
    }

    public Object visitExpand(Expand elm, State state) {
        Iterable list = (Iterable)this.visitExpression((Expression)elm.getOperand().get(0), state);
        Quantity per = (Quantity)this.visitExpression((Expression)elm.getOperand().get(1), state);
        return ExpandEvaluator.expand(list, per, state);
    }

    public Object visitExpandValueSet(ExpandValueSet elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ExpandValueSetEvaluator.expand(operand, state);
    }

    public Object visitExp(Exp elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return ExpEvaluator.exp(operand);
    }

    public Object visitFilter(Filter elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        Object condition = this.visitExpression(elm.getCondition(), state);
        return FilterEvaluator.filter(elm, source, condition, state);
    }

    public Object visitFirst(First elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return FirstEvaluator.first(source);
    }

    public Object visitFlatten(Flatten elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return FlattenEvaluator.flatten(operand);
    }

    public Object visitFloor(Floor elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return FloorEvaluator.floor(operand);
    }

    public Object visitForEach(ForEach elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        Object element = this.visitExpression(elm.getElement(), state);
        return ForEachEvaluator.forEach(source, element, state);
    }

    public Object visitGeometricMean(GeometricMean elm, State state) {
        Iterable source = (Iterable)this.visitExpression(elm.getSource(), state);
        return GeometricMeanEvaluator.geometricMean(source, state);
    }

    public Object visitHighBoundary(HighBoundary elm, State state) {
        Object input = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object precision = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return HighBoundaryEvaluator.highBoundary(input, precision);
    }

    public Object visitIdentifierRef(IdentifierRef elm, State state) {
        return IdentifierRefEvaluator.internalEvaluate(elm.getName(), state);
    }

    public Object visitIf(If elm, State state) {
        return IfEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitImplies(Implies elm, State state) {
        Boolean left = (Boolean)this.visitExpression((Expression)elm.getOperand().get(0), state);
        Boolean right = (Boolean)this.visitExpression((Expression)elm.getOperand().get(1), state);
        return ImpliesEvaluator.implies(left, right);
    }

    public Object visitIncludedIn(IncludedIn elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return IncludedInEvaluator.internalEvaluate(left, right, precision, state);
    }

    public Object visitIncludes(Includes elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return IncludesEvaluator.internalEvaluate(left, right, precision, state);
    }

    public Object visitIndexOf(IndexOf elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        Object element = this.visitExpression(elm.getElement(), state);
        return IndexOfEvaluator.indexOf(source, element, state);
    }

    public Object visitIndexer(Indexer elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return IndexerEvaluator.indexer(left, right);
    }

    public Object visitIn(In elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return InEvaluator.internalEvaluate(left, right, precision, state);
    }

    public Object visitInstance(Instance elm, State state) {
        return InstanceEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitIntersect(Intersect elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return IntersectEvaluator.intersect(left, right, state);
    }

    public Object visitInterval(Interval elm, State state) {
        return IntervalEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitIs(Is elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return IsEvaluator.internalEvaluate(elm, operand, state);
    }

    public Object visitIsFalse(IsFalse elm, State state) {
        Boolean operand = (Boolean)this.visitExpression(elm.getOperand(), state);
        return IsFalseEvaluator.isFalse(operand);
    }

    public Object visitIsNull(IsNull elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return IsNullEvaluator.isNull(operand);
    }

    public Object visitIsTrue(IsTrue elm, State state) {
        Boolean operand = (Boolean)this.visitExpression(elm.getOperand(), state);
        return IsTrueEvaluator.isTrue(operand);
    }

    public Object visitLast(Last elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return LastEvaluator.last(source);
    }

    public Object visitLastPositionOf(LastPositionOf elm, State state) {
        Object string = this.visitExpression(elm.getString(), state);
        Object pattern = this.visitExpression(elm.getPattern(), state);
        return LastPositionOfEvaluator.lastPositionOf(string, pattern);
    }

    public Object visitLength(Length elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return LengthEvaluator.internalEvaluate(operand, elm, state);
    }

    public Object visitLess(Less elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return LessEvaluator.less(left, right, state);
    }

    public Object visitLessOrEqual(LessOrEqual elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return LessOrEqualEvaluator.lessOrEqual(left, right, state);
    }

    public Object visitLiteral(Literal literal, State state) {
        return LiteralEvaluator.internalEvaluate(literal.getValueType(), literal.getValue(), state);
    }

    public Object visitList(List elm, State state) {
        return ListEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitLn(Ln elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return LnEvaluator.ln(operand);
    }

    public Object visitLog(Log elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return LogEvaluator.log(left, right);
    }

    public Object visitLowBoundary(LowBoundary elm, State state) {
        Object input = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object precision = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return LowBoundaryEvaluator.lowBoundary(input, precision);
    }

    public Object visitLower(Lower elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return LowerEvaluator.lower(operand);
    }

    public Object visitMatches(Matches elm, State state) {
        String argument = (String)this.visitExpression((Expression)elm.getOperand().get(0), state);
        String pattern = (String)this.visitExpression((Expression)elm.getOperand().get(1), state);
        return MatchesEvaluator.matches(argument, pattern);
    }

    public Object visitMax(Max elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return MaxEvaluator.max(source, state);
    }

    public Object visitMaxValue(MaxValue elm, State state) {
        return MaxValueEvaluator.internalEvaluate(elm.getValueType(), state);
    }

    public Object visitMessage(Message elm, State state) {
        return MessageEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitMin(Min elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return MinEvaluator.min(source, state);
    }

    public Object visitMinValue(MinValue elm, State state) {
        return MinValueEvaluator.internalEvaluate(elm.getValueType(), state);
    }

    public Object visitMode(Mode elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return ModeEvaluator.mode(source, state);
    }

    public Object visitModulo(Modulo elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return ModuloEvaluator.modulo(left, right);
    }

    public Object visitMultiply(Multiply elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return MultiplyEvaluator.multiply(left, right);
    }

    public Object visitNegate(Negate elm, State state) {
        return NegateEvaluator.internalEvaluate(elm.getOperand(), state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitNotEqual(NotEqual elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return NotEqualEvaluator.notEqual(left, right, state);
    }

    public Object visitNot(Not elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return NotEvaluator.not(operand);
    }

    public Object visitNow(Now elm, State state) {
        return NowEvaluator.internalEvaluate(state);
    }

    public Object visitNull(Null elm, State state) {
        return NullEvaluator.internalEvaluate(state);
    }

    public Object visitOperandRef(OperandRef elm, State state) {
        return OperandRefEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitOr(Or elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return OrEvaluator.or(left, right);
    }

    public Object visitOverlapsAfter(OverlapsAfter elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return OverlapsAfterEvaluator.overlapsAfter(left, right, precision, state);
    }

    public Object visitOverlapsBefore(OverlapsBefore elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return OverlapsBeforeEvaluator.overlapsBefore(left, right, precision, state);
    }

    public Object visitOverlaps(Overlaps elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() == null ? null : elm.getPrecision().value();
        return OverlapsEvaluator.overlaps(left, right, precision, state);
    }

    public Object visitParameterRef(ParameterRef elm, State state) {
        return ParameterRefEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitPointFrom(PointFrom elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        return PointFromEvaluator.pointFrom(operand, state);
    }

    public Object visitPopulationStdDev(PopulationStdDev elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return PopulationStdDevEvaluator.popStdDev(source, state);
    }

    public Object visitPopulationVariance(PopulationVariance elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return PopulationVarianceEvaluator.popVariance(source, state);
    }

    public Object visitPositionOf(PositionOf elm, State state) {
        Object pattern = this.visitExpression(elm.getPattern(), state);
        Object string = this.visitExpression(elm.getString(), state);
        return PositionOfEvaluator.positionOf(pattern, string);
    }

    public Object visitPower(Power elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        return PowerEvaluator.power(left, right);
    }

    public Object visitPrecision(Precision elm, State state) {
        Object argument = this.visitExpression(elm.getOperand(), state);
        return PrecisionEvaluator.precision(argument);
    }

    public Object visitPredecessor(Predecessor elm, State state) {
        Object argument = this.visitExpression(elm.getOperand(), state);
        return PredecessorEvaluator.predecessor(argument);
    }

    public Object visitProduct(Product elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        return ProductEvaluator.product(source);
    }

    public Object visitProperContains(ProperContains elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return ProperContainsEvaluator.properContains(left, right, precision, state);
    }

    public Object visitProperIncludedIn(ProperIncludedIn elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return ProperIncludedInEvaluator.properlyIncludedIn(left, right, precision, state);
    }

    public Object visitProperIncludes(ProperIncludes elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return ProperIncludesEvaluator.properlyIncludes(left, right, precision, state);
    }

    public Object visitProperIn(ProperIn elm, State state) {
        Object left = this.visitExpression((Expression)elm.getOperand().get(0), state);
        Object right = this.visitExpression((Expression)elm.getOperand().get(1), state);
        String precision = elm.getPrecision() != null ? elm.getPrecision().value() : null;
        return ProperInEvaluator.internalEvaluate(left, right, precision, state);
    }

    public Object visitProperty(Property elm, State state) {
        return PropertyEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitQuantity(org.hl7.elm.r1.Quantity elm, State state) {
        return QuantityEvaluator.internalEvaluate(elm, state);
    }

    public Object visitRound(Round elm, State state) {
        Object operand = this.visitExpression(elm.getOperand(), state);
        Object precision = elm.getPrecision() == null ? null : this.visitExpression(elm.getPrecision(), state);
        return RoundEvaluator.round(operand, precision);
    }

    public Object visitRetrieve(Retrieve elm, State state) {
        return RetrieveEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitReplaceMatches(ReplaceMatches elm, State state) {
        String argument = (String)this.visitExpression((Expression)elm.getOperand().get(0), state);
        String pattern = (String)this.visitExpression((Expression)elm.getOperand().get(1), state);
        String substitution = (String)this.visitExpression((Expression)elm.getOperand().get(2), state);
        return ReplaceMatchesEvaluator.replaceMatches(argument, pattern, substitution);
    }

    public Object visitRepeat(Repeat elm, State state) {
        Object source = this.visitExpression(elm.getSource(), state);
        Object element = this.visitExpression(elm.getElement(), state);
        String scope = elm.getScope();
        return RepeatEvaluator.internalEvaluate(source, element, scope, state);
    }

    public Object visitRatio(Ratio elm, State state) {
        return RatioEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }

    public Object visitQueryLetRef(QueryLetRef elm, State state) {
        return QueryLetRefEvaluator.internalEvaluate(elm, state);
    }

    public Object visitQuery(Query elm, State state) {
        return QueryEvaluator.internalEvaluate(elm, state, (ElmLibraryVisitor<Object, State>)this);
    }
}

