/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.hl7.elm.r1.As;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;

public class ContainsEvaluator {
    public static Object contains(Object left, Object right, String precision, State state) {
        try {
            return InEvaluator.in(right, left, precision, state);
        }
        catch (InvalidOperatorArgument e) {
            throw new InvalidOperatorArgument("Contains(List<T>, T)", String.format("Contains(%s, %s)", left.getClass().getName(), right.getClass().getName()));
        }
    }

    public static Object internalEvaluate(Object left, Object right, Object expression, String precision, State state) {
        if (left == null && right != null) {
            return false;
        }
        if (right == null) {
            return null;
        }
        if (expression instanceof As) {
            if (((As)expression).getAsTypeSpecifier() instanceof IntervalTypeSpecifier) {
                return InEvaluator.in(right, left, precision, state);
            }
            return InEvaluator.in(right, left, null, state);
        }
        return ContainsEvaluator.contains(left, right, precision, state);
    }
}

