/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import org.hl7.elm.r1.TypeSpecifier;
import org.opencds.cqf.cql.engine.exception.InvalidConversion;
import org.opencds.cqf.cql.engine.execution.State;

public class ConvertEvaluator {
    private static Class<?> resolveType(QName toType, TypeSpecifier typeSpecifier, State state) {
        if (typeSpecifier != null) {
            return state.getEnvironment().resolveType(typeSpecifier);
        }
        return state.getEnvironment().resolveType(toType);
    }

    private static Object convert(Object operand, Class<?> type) {
        if (operand == null) {
            return null;
        }
        try {
            if (type.isInstance(operand)) {
                Class<?> cls = operand.getClass();
                return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvalidConversion("Error during conversion: " + e.getMessage());
        }
        throw new InvalidConversion(operand, type);
    }

    public static Object internalEvaluate(Object operand, QName toType, TypeSpecifier typeSpecifier, State state) {
        Class<?> type = ConvertEvaluator.resolveType(toType, typeSpecifier, state);
        return ConvertEvaluator.convert(operand, type);
    }
}

