/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.opencds.cqf.cql.engine.elm.executing.AvgEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DivideEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.MultiplyEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SubtractEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SumEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class VarianceEvaluator {
    public static Object variance(Object source, State state) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            if (((List)source).isEmpty()) {
                return null;
            }
            Object mean = AvgEvaluator.avg(source, state);
            ArrayList<Object> newVals = new ArrayList<Object>();
            for (Object element : (Iterable)source) {
                if (element == null) continue;
                if (element instanceof BigDecimal || element instanceof Quantity) {
                    newVals.add(MultiplyEvaluator.multiply(SubtractEvaluator.subtract(element, mean), SubtractEvaluator.subtract(element, mean)));
                    continue;
                }
                throw new InvalidOperatorArgument("Variance(List<Decimal>) or Variance(List<Quantity>)", String.format("Variance(List<%s>)", element.getClass().getName()));
            }
            return DivideEvaluator.divide(SumEvaluator.sum(newVals), new BigDecimal(newVals.size() - 1), state);
        }
        throw new InvalidOperatorArgument("Variance(List<Decimal>) or Variance(List<Quantity>)", String.format("Variance(%s)", source.getClass().getName()));
    }
}

