/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.UndefinedResult;

public class ExpEvaluator {
    public static Object exp(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof BigDecimal) {
            try {
                return BigDecimal.valueOf(Math.exp(((BigDecimal)operand).doubleValue()));
            }
            catch (NumberFormatException nfe) {
                if (((BigDecimal)operand).compareTo(new BigDecimal(0)) > 0) {
                    throw new UndefinedResult("Results in positive infinity");
                }
                if (((BigDecimal)operand).compareTo(new BigDecimal(0)) < 0) {
                    throw new UndefinedResult("Results in negative infinity");
                }
                throw new UndefinedResult(nfe.getMessage());
            }
        }
        throw new InvalidOperatorArgument("Exp(Decimal)", String.format("Exp(%s)", operand.getClass().getName()));
    }
}

