/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterRefEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ParameterRefEvaluator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internalEvaluate(ParameterRef parameterRef, State state, ElmLibraryVisitor<Object, State> visitor) {
        boolean enteredLibrary = state.enterLibrary(parameterRef.getLibraryName());
        try {
            ParameterDef parameterDef = Libraries.resolveParameterRef(parameterRef.getName(), state.getCurrentLibrary());
            String name = parameterDef.getName();
            String libraryName = state.getCurrentLibrary().getIdentifier().getId();
            String fullName = String.format("%s.%s", libraryName, name);
            if (state.getParameters().containsKey(fullName)) {
                Object object = state.getParameters().get(fullName);
                return object;
            }
            if (state.getParameters().containsKey(parameterDef.getName())) {
                log.debug("Using global value for parameter \"{}\" while evaluating in library \"{}\"", (Object)parameterDef.getName(), (Object)state.getCurrentLibrary().getIdentifier().getId());
                Object object = state.getParameters().get(parameterDef.getName());
                return object;
            }
            Object result = parameterDef.getDefault() != null ? visitor.visitExpression(parameterDef.getDefault(), (Object)state) : null;
            state.getParameters().put(fullName, result);
            Object object = result;
            return object;
        }
        finally {
            state.exitLibrary(enteredLibrary);
        }
    }
}

