/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;

public class SubstringEvaluator {
    public static Object substring(Object stringValue, Object startIndexValue, Object lengthValue) {
        if (stringValue == null || startIndexValue == null) {
            return null;
        }
        if (stringValue instanceof String && startIndexValue instanceof Integer) {
            String string = (String)stringValue;
            Integer startIndex = (Integer)startIndexValue;
            if (startIndex < 0 || startIndex >= string.length()) {
                return null;
            }
            if (lengthValue == null) {
                return string.substring(startIndex);
            }
            int endIndex = startIndex + (Integer)lengthValue;
            if (endIndex > string.length()) {
                endIndex = string.length();
            }
            if (endIndex < startIndex) {
                endIndex = startIndex;
            }
            return string.substring(startIndex, endIndex);
        }
        throw new InvalidOperatorArgument("Substring(String, Integer) or Substring(String, Integer, Integer)", String.format("Substring(%s, %s%s)", stringValue.getClass().getName(), startIndexValue.getClass().getName(), lengthValue == null ? "" : ", " + lengthValue.getClass().getName()));
    }
}

