/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.opencds.cqf.cql.engine.exception.InvalidPrecision;

public enum Precision {
    YEAR,
    MONTH,
    WEEK,
    DAY,
    HOUR,
    MINUTE,
    SECOND,
    MILLISECOND;


    public ChronoField toChronoField() {
        switch (this.ordinal()) {
            case 0: {
                return ChronoField.YEAR;
            }
            case 1: {
                return ChronoField.MONTH_OF_YEAR;
            }
            case 3: {
                return ChronoField.DAY_OF_MONTH;
            }
            case 4: {
                return ChronoField.HOUR_OF_DAY;
            }
            case 5: {
                return ChronoField.MINUTE_OF_HOUR;
            }
            case 6: {
                return ChronoField.SECOND_OF_MINUTE;
            }
        }
        return ChronoField.MILLI_OF_SECOND;
    }

    public ChronoUnit toChronoUnit() {
        switch (this.ordinal()) {
            case 0: {
                return ChronoUnit.YEARS;
            }
            case 1: {
                return ChronoUnit.MONTHS;
            }
            case 3: {
                return ChronoUnit.DAYS;
            }
            case 4: {
                return ChronoUnit.HOURS;
            }
            case 5: {
                return ChronoUnit.MINUTES;
            }
            case 6: {
                return ChronoUnit.SECONDS;
            }
        }
        return ChronoUnit.MILLIS;
    }

    public int toDateIndex() {
        switch (this.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public int toDateTimeIndex() {
        switch (this.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
        }
        return 6;
    }

    public int toTimeIndex() {
        switch (this.ordinal()) {
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        return 3;
    }

    public Precision getNextPrecision() {
        switch (this.ordinal()) {
            case 0: {
                return MONTH;
            }
            case 1: {
                return DAY;
            }
            case 3: {
                return HOUR;
            }
            case 4: {
                return MINUTE;
            }
            case 5: {
                return SECOND;
            }
            case 6: {
                return MILLISECOND;
            }
        }
        return MILLISECOND;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "year";
            }
            case 1: {
                return "month";
            }
            case 2: {
                return "week";
            }
            case 3: {
                return "day";
            }
            case 4: {
                return "hour";
            }
            case 5: {
                return "minute";
            }
            case 6: {
                return "second";
            }
        }
        return "millisecond";
    }

    public static Precision fromString(String precision) {
        if ((precision = precision.toLowerCase()).startsWith("year")) {
            return YEAR;
        }
        if (precision.startsWith("month")) {
            return MONTH;
        }
        if (precision.startsWith("day")) {
            return DAY;
        }
        if (precision.startsWith("week")) {
            return WEEK;
        }
        if (precision.startsWith("hour")) {
            return HOUR;
        }
        if (precision.startsWith("minute")) {
            return MINUTE;
        }
        if (precision.startsWith("second")) {
            return SECOND;
        }
        if (precision.startsWith("millisecond")) {
            return MILLISECOND;
        }
        throw new InvalidPrecision("Invalid precision: " + precision);
    }

    public static Precision fromDateIndex(int index) {
        switch (index) {
            case 0: {
                return YEAR;
            }
            case 1: {
                return MONTH;
            }
            case 2: {
                return DAY;
            }
        }
        throw new InvalidPrecision("Invalid precision index: " + Integer.toString(index));
    }

    public static Precision fromDateTimeIndex(int index) {
        switch (index) {
            case 0: {
                return YEAR;
            }
            case 1: {
                return MONTH;
            }
            case 2: {
                return DAY;
            }
            case 3: {
                return HOUR;
            }
            case 4: {
                return MINUTE;
            }
            case 5: {
                return SECOND;
            }
            case 6: {
                return MILLISECOND;
            }
        }
        throw new InvalidPrecision("Invalid precision index: " + Integer.toString(index));
    }

    public static Precision fromTimeIndex(int index) {
        return Precision.fromDateTimeIndex(index + 3);
    }

    public static ChronoField getDateChronoFieldFromIndex(int index) {
        switch (index) {
            case 0: {
                return ChronoField.YEAR;
            }
            case 1: {
                return ChronoField.MONTH_OF_YEAR;
            }
            case 2: {
                return ChronoField.DAY_OF_MONTH;
            }
        }
        throw new InvalidPrecision("Invalid precision index: " + Integer.toString(index));
    }

    public static ChronoField getDateTimeChronoFieldFromIndex(int index) {
        switch (index) {
            case 0: {
                return ChronoField.YEAR;
            }
            case 1: {
                return ChronoField.MONTH_OF_YEAR;
            }
            case 2: {
                return ChronoField.DAY_OF_MONTH;
            }
            case 3: {
                return ChronoField.HOUR_OF_DAY;
            }
            case 4: {
                return ChronoField.MINUTE_OF_HOUR;
            }
            case 5: {
                return ChronoField.SECOND_OF_MINUTE;
            }
            case 6: {
                return ChronoField.MILLI_OF_SECOND;
            }
        }
        throw new InvalidPrecision("Invalid precision index: " + Integer.toString(index));
    }

    public static ChronoField getTimeChronoFieldFromIndex(int index) {
        return Precision.getDateTimeChronoFieldFromIndex(index + 3);
    }

    public static Precision getLowestDatePrecision(Precision p1, Precision p2) {
        return p1.toDateIndex() < p2.toDateIndex() ? p1 : p2;
    }

    public static Precision getHighestDatePrecision(Precision p1, Precision p2) {
        return p1.toDateIndex() > p2.toDateIndex() ? p1 : p2;
    }

    public static Precision getLowestDateTimePrecision(Precision p1, Precision p2) {
        return p1.toDateTimeIndex() < p2.toDateTimeIndex() ? p1 : p2;
    }

    public static Precision getHighestDateTimePrecision(Precision p1, Precision p2) {
        return p1.toDateTimeIndex() > p2.toDateTimeIndex() ? p1 : p2;
    }

    public static Precision getLowestTimePrecision(Precision p1, Precision p2) {
        return p1.toTimeIndex() < p2.toTimeIndex() ? p1 : p2;
    }

    public static Precision getHighestTimePrecision(Precision p1, Precision p2) {
        return p1.toTimeIndex() > p2.toTimeIndex() ? p1 : p2;
    }
}

