/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Value;

public class MinValueEvaluator {
    public static Object minValue(String type) {
        if (type == null) {
            return null;
        }
        if (type.endsWith("Integer")) {
            return Value.MIN_INT;
        }
        if (type.endsWith("Long")) {
            return Value.MIN_LONG;
        }
        if (type.endsWith("Decimal")) {
            return Value.MIN_DECIMAL;
        }
        if (type.endsWith("Date")) {
            return new Date(1, 1, 1);
        }
        if (type.endsWith("DateTime")) {
            return new DateTime(BigDecimal.ZERO, 1, 1, 1, 0, 0, 0, 0);
        }
        if (type.endsWith("Time")) {
            return new Time(0, 0, 0, 0);
        }
        if (type.endsWith("Quantity")) {
            return new Quantity().withValue(Value.MIN_DECIMAL).withUnit("1");
        }
        throw new InvalidOperatorArgument(String.format("The Minimum operator is not implemented for type %s", type));
    }

    public static Object internalEvaluate(QName vtype, State state) {
        QName valueType = state.getEnvironment().fixupQName(vtype);
        String type = valueType.getLocalPart();
        return MinValueEvaluator.minValue(type);
    }
}

