/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.hl7.elm.r1.ChoiceTypeSpecifier;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.data.ExternalFunctionProvider;
import org.opencds.cqf.cql.engine.data.SystemDataProvider;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Tuple;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class Environment {
    private final LibraryManager libraryManager;
    private final Map<String, DataProvider> dataProviders = new HashMap<String, DataProvider>();
    private final TerminologyProvider terminologyProvider;
    private Map<String, DataProvider> packageMap = new HashMap<String, DataProvider>();
    private Map<VersionedIdentifier, ExternalFunctionProvider> externalFunctionProviders = new HashMap<VersionedIdentifier, ExternalFunctionProvider>();

    public Environment(LibraryManager libraryManager) {
        this(libraryManager, null, null);
    }

    public Environment(LibraryManager libraryManager, Map<String, DataProvider> dataProviders, TerminologyProvider terminologyProvider) {
        this.libraryManager = libraryManager;
        this.terminologyProvider = terminologyProvider;
        if (dataProviders != null) {
            for (Map.Entry<String, DataProvider> dp : dataProviders.entrySet()) {
                this.registerDataProvider(dp.getKey(), dp.getValue());
            }
        }
        if (!this.dataProviders.containsKey("urn:hl7-org:elm-types:r1")) {
            this.registerDataProvider("urn:hl7-org:elm-types:r1", new SystemDataProvider());
        }
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public Map<String, DataProvider> getDataProviders() {
        return this.dataProviders;
    }

    public TerminologyProvider getTerminologyProvider() {
        return this.terminologyProvider;
    }

    public void registerExternalFunctionProvider(VersionedIdentifier identifier, ExternalFunctionProvider provider) {
        this.externalFunctionProviders.put(identifier, provider);
    }

    public ExternalFunctionProvider getExternalFunctionProvider(VersionedIdentifier identifier) {
        ExternalFunctionProvider provider = this.externalFunctionProviders.get(identifier);
        if (provider == null) {
            throw new CqlException(String.format("Could not resolve external function provider for library '%s'.", identifier));
        }
        return provider;
    }

    public Object resolvePath(Object target, String path) {
        if (target == null) {
            return null;
        }
        Class<?> clazz = target.getClass();
        if (clazz.getPackage().getName().startsWith("java.lang")) {
            throw new CqlException(String.format("Invalid path: %s for type: %s - this is likely an issue with the data model.", path, clazz.getName()));
        }
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        return dataProvider.resolvePath(target, path);
    }

    public Object as(Object operand, Class<?> type, boolean isStrict) {
        if (operand == null) {
            return null;
        }
        if (type.isAssignableFrom(operand.getClass())) {
            return operand;
        }
        DataProvider provider = this.resolveDataProvider(type.getPackage().getName(), false);
        if (provider != null) {
            return provider.as(operand, type, isStrict);
        }
        return null;
    }

    public Boolean objectEqual(Object left, Object right) {
        if (left == null) {
            return null;
        }
        Class<?> clazz = left.getClass();
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        return dataProvider.objectEqual(left, right);
    }

    public Boolean objectEquivalent(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        Class<?> clazz = left.getClass();
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        return dataProvider.objectEquivalent(left, right);
    }

    public Object createInstance(QName typeName) {
        typeName = this.fixupQName(typeName);
        DataProvider dataProvider = this.resolveDataProvider(typeName);
        return dataProvider.createInstance(typeName.getLocalPart());
    }

    public void setValue(Object target, String path, Object value) {
        if (target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        dataProvider.setValue(target, path, value);
    }

    public Boolean is(Object operand, Class<?> type) {
        if (operand == null) {
            return null;
        }
        if (type.isAssignableFrom(operand.getClass())) {
            return true;
        }
        DataProvider provider = this.resolveDataProvider(type.getPackage().getName(), false);
        if (provider != null) {
            return provider.is(operand, type);
        }
        return false;
    }

    public void registerDataProvider(String modelUri, DataProvider dataProvider) {
        this.dataProviders.put(modelUri, dataProvider);
        dataProvider.getPackageNames().forEach(pn -> this.packageMap.put((String)pn, dataProvider));
    }

    public DataProvider resolveDataProvider(QName dataType) {
        DataProvider dataProvider = this.dataProviders.get((dataType = this.fixupQName(dataType)).getNamespaceURI());
        if (dataProvider == null) {
            throw new CqlException(String.format("Could not resolve data provider for model '%s'.", dataType.getNamespaceURI()));
        }
        return dataProvider;
    }

    public DataProvider resolveDataProviderByModelUri(String modelUri) {
        DataProvider dataProvider = this.dataProviders.get(modelUri);
        if (dataProvider == null) {
            throw new CqlException(String.format("Could not resolve data provider for model '%s'.", modelUri));
        }
        return dataProvider;
    }

    public DataProvider resolveDataProvider(String packageName) {
        return this.resolveDataProvider(packageName, true);
    }

    public DataProvider resolveDataProvider(String packageName, boolean mustResolve) {
        DataProvider dataProvider = this.packageMap.get(packageName);
        if (dataProvider == null && mustResolve) {
            throw new CqlException(String.format("Could not resolve data provider for package '%s'.", packageName));
        }
        return dataProvider;
    }

    public Class<?> resolveType(QName typeName) {
        typeName = this.fixupQName(typeName);
        DataProvider dataProvider = this.resolveDataProvider(typeName);
        return dataProvider.resolveType(typeName.getLocalPart());
    }

    public Class<?> resolveType(TypeSpecifier typeSpecifier) {
        if (typeSpecifier instanceof NamedTypeSpecifier) {
            return this.resolveType(((NamedTypeSpecifier)typeSpecifier).getName());
        }
        if (typeSpecifier instanceof ListTypeSpecifier) {
            return List.class;
        }
        if (typeSpecifier instanceof IntervalTypeSpecifier) {
            return Interval.class;
        }
        if (typeSpecifier instanceof ChoiceTypeSpecifier) {
            return Object.class;
        }
        return Tuple.class;
    }

    public Class<?> resolveType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TypeSpecifier) {
            return this.resolveType((TypeSpecifier)value);
        }
        String packageName = value.getClass().getPackage().getName();
        if (value instanceof Iterable) {
            return List.class;
        }
        if (value instanceof Tuple) {
            return Tuple.class;
        }
        if (packageName.startsWith("java")) {
            return value.getClass();
        }
        DataProvider dataProvider = this.resolveDataProvider(value.getClass().getPackage().getName());
        return dataProvider.resolveType(value);
    }

    public Class<?> resolveOperandType(OperandDef operandDef) {
        if (operandDef.getOperandTypeSpecifier() != null) {
            return this.resolveType(operandDef.getOperandTypeSpecifier());
        }
        return this.resolveType(operandDef.getOperandType());
    }

    public boolean isType(Class<?> argumentType, Class<?> operandType) {
        return argumentType == null || operandType.isAssignableFrom(argumentType);
    }

    public boolean matchesTypes(FunctionDef functionDef, List<? extends Object> arguments) {
        boolean isMatch = true;
        List operands = functionDef.getOperand();
        if (arguments.size() != operands.size()) {
            return false;
        }
        for (int i = 0; i < arguments.size() && (isMatch = this.isType(this.resolveType(arguments.get(i)), this.resolveOperandType((OperandDef)operands.get(i)))); ++i) {
        }
        return isMatch;
    }

    public QName fixupQName(QName typeName) {
        int closeIndex;
        if ((typeName.getNamespaceURI() == null || typeName.getNamespaceURI().isEmpty()) && typeName.getLocalPart() != null && typeName.getLocalPart().startsWith("{") && (closeIndex = typeName.getLocalPart().indexOf(125)) > 0 && typeName.getLocalPart().length() > closeIndex) {
            return new QName(typeName.getLocalPart().substring(1, closeIndex), typeName.getLocalPart().substring(closeIndex + 1));
        }
        return typeName;
    }

    public Library resolveLibrary(VersionedIdentifier identifier) {
        return this.libraryManager.resolveLibrary(identifier).getLibrary();
    }
}

